(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    273226,       6059]
NotebookOptionsPosition[    259995,       5731]
NotebookOutlinePosition[    260381,       5747]
CellTagsIndexPosition[    260338,       5744]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Math 203 - Multivariable Calculus", "Title",
 CellChangeTimes->{{3.7132352480035334`*^9, 3.7132352566671543`*^9}, {
  3.7132353840015993`*^9, 
  3.713235386162277*^9}},ExpressionUUID->"3eff84e4-7dc3-473c-9d5f-\
5004e7960755"],

Cell[CellGroupData[{

Cell[TextData[{
 "Prerequisite Worksheet and First Mathematica Commands\n",
 StyleBox["September 4, 2017", "Subchapter"]
}], "Chapter",
 CellChangeTimes->{{3.7132354004820967`*^9, 3.713235406034102*^9}, {
  3.713236857004621*^9, 3.713236868548688*^9}, {3.7134660159867067`*^9, 
  3.7134660259792247`*^9}},ExpressionUUID->"c892a7ab-be06-4eb0-8538-\
11c3495d3863"],

Cell["\<\
This link has a list of keyboard shortcuts for Mathematica. This can make \
entering integrals, derivatives, and other things easier! \
\>", "Text",
 CellChangeTimes->{{3.7134655860006123`*^9, 3.713465664555203*^9}, {
  3.713465698217385*^9, 3.713465718323245*^9}, {3.7134658334571447`*^9, 
  3.713465872458172*^9}},ExpressionUUID->"76986328-9708-4592-8069-\
c192c864c775"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hyperlink", "[", 
  RowBox[{
  "\"\<Keyboard Shortcuts\>\"", ",", 
   "\"\<http://reference.wolfram.com/language/tutorial/\
KeyboardShortcutListing.html\>\""}], "]"}]], "Code",
 CellOpen->False,
 CellChangeTimes->{{3.7134655860006123`*^9, 3.713465664555203*^9}, {
  3.713465698217385*^9, 
  3.7134657576928744`*^9}},ExpressionUUID->"3191ef1e-9de0-4ec2-9679-\
4ed8e3e8381a"],

Cell[BoxData[
 TagBox[
  ButtonBox[
   PaneSelectorBox[{False->"\<\"Keyboard Shortcuts\"\>", True->
    StyleBox["\<\"Keyboard Shortcuts\"\>", "HyperlinkActive"]}, Dynamic[
     CurrentValue["MouseOver"]],
    BaseStyle->{"Hyperlink"},
    FrameMargins->0,
    ImageSize->Automatic],
   BaseStyle->"Hyperlink",
   ButtonData->{
     URL["http://reference.wolfram.com/language/tutorial/\
KeyboardShortcutListing.html"], None},
   ButtonNote->
    "http://reference.wolfram.com/language/tutorial/KeyboardShortcutListing.\
html"],
  Annotation[#, 
   "http://reference.wolfram.com/language/tutorial/KeyboardShortcutListing.\
html", "Hyperlink"]& ]], "Output",
 CellChangeTimes->{3.713465760187833*^9, 
  3.7135501573529105`*^9},ExpressionUUID->"d889dbb2-edf6-456f-94fb-\
bf03ad948e37"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 1", "Section",
 CellChangeTimes->{{3.7132354217860603`*^9, 3.713235422873678*^9}, {
  3.7132357083691387`*^9, 
  3.713235713385277*^9}},ExpressionUUID->"4a24de52-2102-4d1e-9650-\
526a5cece368"],

Cell[TextData[{
 "Find the derivative of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", " ", 
     RowBox[{"(", "x", ")"}]}], " ", "=", " ", 
    RowBox[{
     SuperscriptBox["x", "2"], 
     RowBox[{"cos", "(", 
      RowBox[{
       SuperscriptBox["x", "3"], "+", "1"}], ")"}]}]}], TraditionalForm]],
  ExpressionUUID->"8391647e-f539-4236-85e0-1857d588786c"],
 "."
}], "Text",
 CellChangeTimes->{{3.7132354651251163`*^9, 3.7132354905056725`*^9}, {
   3.7132355461840343`*^9, 3.7132355869563646`*^9}, {3.7132356260175753`*^9, 
   3.713235665881236*^9}, 
   3.713236389570219*^9},ExpressionUUID->"96f24a6d-bfed-4a41-8f0d-\
b370d8e10799"],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.7135500014545116`*^9, 
  3.713550002286007*^9}},ExpressionUUID->"239273d6-da02-4260-b758-\
87b6f0338a92"],

Cell["This requires both the product rule and the chain rule:", "Text",
 CellChangeTimes->{{3.7132354651251163`*^9, 3.7132354905056725`*^9}, {
   3.7132355461840343`*^9, 3.7132355869563646`*^9}, {3.7132356260175753`*^9, 
   3.713235665881236*^9}, {3.71354957364501*^9, 3.7135498484165325`*^9}, 
   3.713550739873883*^9},ExpressionUUID->"1f3de8a8-1523-4789-a223-\
2fdcd97a950c"],

Cell[TextData[{
 "\n",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{
     RowBox[{"f", "'"}], 
     RowBox[{"(", "x", ")"}], 
     "\[AlignmentMarker]\[AlignmentMarker]\[AlignmentMarker]\[AlignmentMarker]\
\[AlignmentMarker]", "=", 
     RowBox[{
      RowBox[{
       FractionBox["d", "dx"], "[", 
       RowBox[{
        SuperscriptBox["x", "2"], 
        RowBox[{"cos", "(", 
         RowBox[{
          SuperscriptBox["x", "3"], "+", "1"}], ")"}]}], "]"}], "=", 
      RowBox[{
       RowBox[{
        RowBox[{
         FractionBox["d", "dx"], 
         RowBox[{"(", 
          SuperscriptBox["x", "2"], ")"}], 
         RowBox[{"cos", "(", 
          RowBox[{
           SuperscriptBox["x", "3"], "+", "1"}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["x", "2"], 
         RowBox[{
          FractionBox["d", "dx"], "[", 
          RowBox[{"cos", "(", 
           RowBox[{
            SuperscriptBox["x", "3"], "+", "1"}], ")"}], "]"}]}]}], " ", 
       "\[IndentingNewLine]", "\[AlignmentMarker]", "=", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"2", "x", " ", 
          RowBox[{"cos", "(", 
           RowBox[{
            SuperscriptBox["x", "3"], "+", "1"}], ")"}]}], " ", "-", 
         RowBox[{
          SuperscriptBox["x", "2"], 
          RowBox[{"sin", "(", 
           RowBox[{
            SuperscriptBox["x", "3"], "+", "1"}], ")"}], 
          RowBox[{"(", 
           RowBox[{"3", 
            SuperscriptBox["x", "2"]}], ")"}]}]}], "\[IndentingNewLine]", "=", 
        RowBox[{
         RowBox[{"2", "x", " ", 
          RowBox[{"cos", "(", 
           RowBox[{
            SuperscriptBox["x", "3"], "+", "1"}], ")"}]}], " ", "-", " ", 
         RowBox[{"3", 
          SuperscriptBox["x", "4"], 
          RowBox[{"sin", "(", 
           RowBox[{
            SuperscriptBox["x", "3"], "+", "1"}], ")"}]}]}]}]}]}]}],
    FontSize->18], TraditionalForm]],ExpressionUUID->
  "3f0aa1a0-5e88-4355-af12-286d03c5f0e2"]
}], "Text",
 CellChangeTimes->{{3.7132354651251163`*^9, 3.7132354905056725`*^9}, {
  3.7132355461840343`*^9, 3.7132355869563646`*^9}, {3.7132356260175753`*^9, 
  3.713235665881236*^9}, {3.71354957364501*^9, 3.7135498484165325`*^9}, {
  3.713550794463457*^9, 3.713550797759737*^9}, {3.713550861664124*^9, 
  3.713550932449793*^9}, {3.713621907186548*^9, 3.713621924356566*^9}},
 TextAlignment->
  AlignmentMarker,ExpressionUUID->"73d05611-7b99-4c37-9f81-e1ceb6241b8e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 2", "Section",
 CellChangeTimes->{{3.7132357351372943`*^9, 
  3.7132357361843896`*^9}},ExpressionUUID->"38cc62da-8763-4d8f-ac77-\
780f62bc6421"],

Cell[TextData[{
 "Find ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox["dy", "dx"],
    FontSize->18], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "15abb496-221d-4d1f-86ca-074d2c3275bb"],
 " where ",
 StyleBox["y", "InlineFormula"],
 " is implicitly defined as a function of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "041493a2-2250-4a99-8aa9-1b4a501c90a7"],
 " by the equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"3", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "+", 
        SuperscriptBox["y", "2"]}], ")"}], "2"]}], "=", 
    RowBox[{"100", 
     RowBox[{"xy", "."}]}]}], TraditionalForm]],ExpressionUUID->
  "8c7ec0b7-04c6-470b-a613-0d6b43498d73"]
}], "Text",
 CellChangeTimes->{{3.7132357443530073`*^9, 3.7132357991203194`*^9}, {
   3.713235830129568*^9, 3.7132358474240284`*^9}, {3.713235956456787*^9, 
   3.713235980961725*^9}, {3.713236106702427*^9, 3.713236106702427*^9}, 
   3.713236393953823*^9, {3.71346760532029*^9, 3.7134676333318305`*^9}, {
   3.713467679273142*^9, 3.713467688158902*^9}, {3.7134677205539246`*^9, 
   3.7134677363504906`*^9}},ExpressionUUID->"b251f761-dae6-40ae-93e6-\
30fa8ae2e9d9"],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.7135500105660706`*^9, 
  3.7135500153019533`*^9}},ExpressionUUID->"bf022f1e-391d-4bed-b8a3-\
8157d46db6f1"],

Cell["Begin by taking the derivative of both sides:", "Text",
 CellChangeTimes->{{3.7132357443530073`*^9, 3.7132357991203194`*^9}, {
  3.713235830129568*^9, 3.7132358474240284`*^9}, {3.713235956456787*^9, 
  3.713235980961725*^9}, {3.713236106702427*^9, 3.713236106702427*^9}, {
  3.713567546511058*^9, 
  3.7135675711885414`*^9}},ExpressionUUID->"ddea3346-5bb2-49b5-a6eb-\
997972bc2360"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"6", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"]}], ")"}], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", "x"}], "+", 
      RowBox[{"2", "y", 
       FractionBox["dy", "dx"]}]}], ")"}]}], "=", 
   RowBox[{
    RowBox[{"100", "y"}], "+", 
    RowBox[{"100", "x", 
     FractionBox["dy", "dx"]}]}]}], TraditionalForm]],
 FormatType->"TraditionalForm",
 FontSize->18,ExpressionUUID->"9435ed98-4297-4b6f-a777-4b5bb05d2899"]], "Text",
 CellChangeTimes->{{3.7132357443530073`*^9, 3.7132357991203194`*^9}, {
  3.713235830129568*^9, 3.7132358474240284`*^9}, {3.713235956456787*^9, 
  3.713235980961725*^9}, {3.713236106702427*^9, 3.713236106702427*^9}, {
  3.713567546511058*^9, 3.713567652769723*^9}},
 TextAlignment->Center,ExpressionUUID->"45dac899-fedf-46c4-aa5b-0a57b4d722bb"],

Cell["Multiply out the left hand side:", "Text",
 CellChangeTimes->{{3.7132357443530073`*^9, 3.7132357991203194`*^9}, {
  3.713235830129568*^9, 3.7132358474240284`*^9}, {3.713235956456787*^9, 
  3.713235980961725*^9}, {3.713236106702427*^9, 3.713236106702427*^9}, {
  3.713567546511058*^9, 3.7135676355703616`*^9}, {3.7135678016481695`*^9, 
  3.713567885647094*^9}},ExpressionUUID->"087bf44b-bd83-4248-a4f3-\
1f4b28107ed7"],

Cell[TextData[Cell[BoxData[
 FormBox[
  StyleBox[
   RowBox[{
    RowBox[{
     RowBox[{"12", 
      SuperscriptBox["x", "3"]}], "+", 
     RowBox[{"12", 
      SuperscriptBox["x", "2"], "y", 
      FractionBox["dy", "dx"]}], "+", 
     RowBox[{"12", 
      SuperscriptBox["xy", "2"]}], "+", 
     RowBox[{"12", "y", 
      FractionBox["dy", "dx"]}]}], "=", 
    RowBox[{
     RowBox[{"100", "y"}], "+", 
     RowBox[{"100", "x", 
      FractionBox["dy", "dx"]}]}]}],
   FontSize->18], TraditionalForm]],
 FormatType->
  "TraditionalForm",ExpressionUUID->"3ec0a51b-0787-4586-8869-6ac822d9b839"]], \
"Text",
 CellChangeTimes->{{3.7132357443530073`*^9, 3.7132357991203194`*^9}, {
  3.713235830129568*^9, 3.7132358474240284`*^9}, {3.713235956456787*^9, 
  3.713235980961725*^9}, {3.713236106702427*^9, 3.713236106702427*^9}, {
  3.713567546511058*^9, 3.7135676355703616`*^9}, {3.7135678016481695`*^9, 
  3.7135678999768715`*^9}},
 TextAlignment->Center,ExpressionUUID->"894f7d8f-a466-4891-8ae7-5e4e1afb008e"],

Cell[TextData[{
 "Now gather all of the terms with ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox["dy", "dx"],
    FontSize->18], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "014b1fb2-58c8-407f-9375-5bf3e0a4f358"],
 "on one side and factor it out:"
}], "Text",
 CellChangeTimes->{{3.7132357443530073`*^9, 3.7132357991203194`*^9}, {
  3.713235830129568*^9, 3.7132358474240284`*^9}, {3.713235956456787*^9, 
  3.713235980961725*^9}, {3.713236106702427*^9, 3.713236106702427*^9}, {
  3.713567546511058*^9, 3.7135676355703616`*^9}, {3.7135678016481695`*^9, 
  3.713567956447853*^9}},ExpressionUUID->"b9938733-edf7-4670-857f-\
60354c62d63c"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"12", 
       SuperscriptBox["x", "2"], "y"}], "+", 
      RowBox[{"12", "y"}], "-", 
      RowBox[{"100", "x"}]}], ")"}], 
    FractionBox["dy", "dx"]}], "=", 
   RowBox[{
    RowBox[{"100", "y"}], "-", 
    RowBox[{"12", 
     SuperscriptBox["x", "3"]}], "-", 
    RowBox[{"12", 
     SuperscriptBox["xy", "2"]}]}]}], TraditionalForm]],
 FormatType->"TraditionalForm",
 FontSize->18,ExpressionUUID->"aff403a0-8c04-4de6-8458-70c5140376aa"]], "Text",
 CellChangeTimes->{{3.7132357443530073`*^9, 3.7132357991203194`*^9}, {
  3.713235830129568*^9, 3.7132358474240284`*^9}, {3.713235956456787*^9, 
  3.713235980961725*^9}, {3.713236106702427*^9, 3.713236106702427*^9}, {
  3.713567546511058*^9, 3.7135676355703616`*^9}, {3.7135678016481695`*^9, 
  3.7135679828412185`*^9}, {3.7135680832304974`*^9, 3.713568095016843*^9}},
 TextAlignment->Center,ExpressionUUID->"21d10baf-ecea-4c91-a82d-54a463d14b0c"],

Cell[TextData[{
 "Finally, isolate",
 StyleBox[" ",
  FontSize->18],
 Cell[BoxData[
  FormBox[
   FractionBox["dy", "dx"], TraditionalForm]],
  FormatType->"TraditionalForm",
  FontSize->18,ExpressionUUID->"e4aa25e7-99d4-474d-87d9-253a7a7c0b1c"],
 ":"
}], "Text",
 CellChangeTimes->{{3.7132357443530073`*^9, 3.7132357991203194`*^9}, {
  3.713235830129568*^9, 3.7132358474240284`*^9}, {3.713235956456787*^9, 
  3.713235980961725*^9}, {3.713236106702427*^9, 3.713236106702427*^9}, {
  3.713567546511058*^9, 3.7135676355703616`*^9}, {3.7135678016481695`*^9, 
  3.7135679828412185`*^9}, {3.7135680832304974`*^9, 
  3.7135681671693583`*^9}},ExpressionUUID->"03aad1fe-d584-49a5-b6bd-\
fb57368eceed"],

Cell[TextData[Cell[BoxData[
 FormBox[
  StyleBox[
   RowBox[{
    FractionBox["dy", "dx"], "=", 
    FractionBox[
     RowBox[{
      RowBox[{"100", "y"}], "-", 
      RowBox[{"12", 
       SuperscriptBox["x", "3"]}], "-", 
      RowBox[{"12", 
       SuperscriptBox["xy", "2"]}]}], 
     RowBox[{
      RowBox[{"12", 
       SuperscriptBox["x", "2"], "y"}], "+", 
      RowBox[{"12", "y"}], "-", 
      RowBox[{"100", "x"}]}]]}],
   FontSize->24], TraditionalForm]],
 FormatType->"TraditionalForm",
 FontSize->18,ExpressionUUID->"39707ef2-09a4-492c-b7bf-8d950522237e"]], "Text",
 CellChangeTimes->{{3.7132357443530073`*^9, 3.7132357991203194`*^9}, {
   3.713235830129568*^9, 3.7132358474240284`*^9}, {3.713235956456787*^9, 
   3.713235980961725*^9}, {3.713236106702427*^9, 3.713236106702427*^9}, {
   3.713567546511058*^9, 3.7135676355703616`*^9}, {3.7135678016481695`*^9, 
   3.7135679828412185`*^9}, {3.7135680832304974`*^9, 3.7135681379484806`*^9}, 
   3.713568171265067*^9},
 TextAlignment->Center,ExpressionUUID->"5c0340f1-b834-4cd1-b857-b93f636255e7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 3", "Section",
 CellChangeTimes->{{3.7132359950315733`*^9, 
  3.713235996879508*^9}},ExpressionUUID->"b558e9de-89e6-468c-a384-\
951f2a0bdef8"],

Cell[TextData[{
 "Find the tangent line to the graph of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"3", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "+", 
        SuperscriptBox["y", "2"]}], ")"}], "2"]}], "=", 
    RowBox[{"100", "xy"}]}], TraditionalForm]],ExpressionUUID->
  "f47d7875-57d3-4a21-aa65-c25fb0b05990"],
 " at the point ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"3", ",", "1"}], ")"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "10fd539b-3f16-4670-a906-489e3f5b8c8d"],
 "."
}], "Text",
 InitializationCell->True,
 CellChangeTimes->{{3.7132362011190834`*^9, 3.7132362168149977`*^9}, {
   3.713236248157117*^9, 3.713236274294656*^9}, 3.713236396338131*^9, {
   3.7132379028992043`*^9, 3.71323792599669*^9}, {3.7134675473040686`*^9, 
   3.7134675859134197`*^9}},ExpressionUUID->"a6e3293d-cf1d-4b62-9efc-\
a0a5552f38fe"],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.7135500204544477`*^9, 
  3.7135500213257084`*^9}},ExpressionUUID->"2e52da40-24e2-4eaa-84bb-\
d6a312e6c6b5"],

Cell["\<\
Remember that the derivative gives the slope of the graph. In Problem 2, we \
found the derivative of this curve, so we can use it to find the slope by \
plugging in the point:\
\>", "Text",
 InitializationCell->True,
 CellChangeTimes->{{3.7132362011190834`*^9, 3.7132362168149977`*^9}, {
  3.713236248157117*^9, 3.713236274294656*^9}, {3.7135683634161987`*^9, 
  3.7135684045667953`*^9}},ExpressionUUID->"1fa24d72-4a7e-48e0-833c-\
39f3c9e93c20"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    FractionBox["dy", "dx"], 
    RowBox[{"(", 
     RowBox[{"3", ",", "1"}], ")"}]}], "=", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"100", 
       RowBox[{"(", "3", ")"}]}], "-", 
      RowBox[{"12", 
       SuperscriptBox[
        RowBox[{"(", "3", ")"}], "3"]}], "-", 
      RowBox[{"12", 
       RowBox[{"(", "3", ")"}], 
       SuperscriptBox[
        RowBox[{"(", "1", ")"}], "2"]}]}], 
     RowBox[{
      RowBox[{"12", 
       SuperscriptBox[
        RowBox[{"(", "3", ")"}], "2"], 
       RowBox[{"(", "1", ")"}]}], "+", 
      RowBox[{"12", 
       RowBox[{"(", "1", ")"}]}], "-", 
      RowBox[{"100", 
       RowBox[{"(", "3", ")"}]}]}]], "=", 
    RowBox[{
     FractionBox[
      RowBox[{"300", "-", "324", "-", "36"}], 
      RowBox[{"108", "+", "12", "-", "300"}]], "=", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["60", "180"]}], "=", 
      RowBox[{"-", 
       FractionBox["1", "3"]}]}]}]}]}], TraditionalForm]],
 TextAlignment->Center,
 FormatType->"TraditionalForm",
 FontSize->18,ExpressionUUID->"e6222ee7-211e-4e40-8cf2-19c79c4dcc45"]], "Text",
 InitializationCell->True,
 CellChangeTimes->{{3.7132362011190834`*^9, 3.7132362168149977`*^9}, {
   3.713236248157117*^9, 3.713236274294656*^9}, {3.7135683634161987`*^9, 
   3.7135685613646774`*^9}, 3.7135688472934856`*^9},
 TextAlignment->Center,ExpressionUUID->"9247a95d-b4c5-418a-8551-3741aa3d9bbd"],

Cell["\<\
Now that we have the slope, we just need to use the point-slope form of a \
line to get the equation of the tangent line:\
\>", "Text",
 InitializationCell->True,
 CellChangeTimes->{{3.7132362011190834`*^9, 3.7132362168149977`*^9}, {
  3.713236248157117*^9, 3.713236274294656*^9}, {3.7135683634161987`*^9, 
  3.7135685613646774`*^9}, {3.7135688488929567`*^9, 
  3.713568874474416*^9}},ExpressionUUID->"1f692ec0-0ac0-46dc-8e32-\
3c38040764c7"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"y", "-", "1"}], "=", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "3"]}], 
    RowBox[{"(", 
     RowBox[{"x", "-", "3"}], ")"}]}]}], TraditionalForm]],
 TextAlignment->Center,
 FormatType->"TraditionalForm",
 FontSize->18,ExpressionUUID->"4ab2ec4c-7e38-41c3-8bf1-6c5ea889b21b"]], "Text",
 InitializationCell->True,
 CellChangeTimes->{{3.7132362011190834`*^9, 3.7132362168149977`*^9}, {
  3.713236248157117*^9, 3.713236274294656*^9}, {3.7135683634161987`*^9, 
  3.7135685613646774`*^9}, {3.7135688488929567`*^9, 3.713568931326598*^9}},
 TextAlignment->Center,ExpressionUUID->"10346f7c-86ee-4915-acd7-c9c5cca46717"],

Cell["which we can simplify to", "Text",
 InitializationCell->True,
 CellChangeTimes->{{3.7132362011190834`*^9, 3.7132362168149977`*^9}, {
  3.713236248157117*^9, 3.713236274294656*^9}, {3.7135683634161987`*^9, 
  3.7135685613646774`*^9}, {3.7135688488929567`*^9, 
  3.713568937557294*^9}},ExpressionUUID->"8cffccb6-1bf1-4b5f-8be0-\
34f9ac463558"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{"y", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "3"]}], "x"}], "+", "2"}]}], TraditionalForm]],
 TextAlignment->Center,
 FormatType->"TraditionalForm",
 FontSize->18,ExpressionUUID->"7dd582c2-250e-4e87-97d0-dcf36a7cc9ab"]], "Text",
 InitializationCell->True,
 CellChangeTimes->{{3.7132362011190834`*^9, 3.7132362168149977`*^9}, {
  3.713236248157117*^9, 3.713236274294656*^9}, {3.7135683634161987`*^9, 
  3.7135685613646774`*^9}, {3.7135688488929567`*^9, 3.7135689534937396`*^9}},
 TextAlignment->Center,ExpressionUUID->"13b764d1-fabc-4800-b922-a7a6558f6c5b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 4", "Section",
 CellChangeTimes->{{3.713235999118843*^9, 
  3.7132360046164513`*^9}},ExpressionUUID->"d9f59dcc-177e-49cd-b037-\
24d5bddbc1a0"],

Cell[TextData[{
 "Compute the integral ",
 Cell[BoxData[
  RowBox[{"\[Integral]", 
   StyleBox[
    RowBox[{
     FractionBox[
      RowBox[{"x", "-", "3"}], 
      RowBox[{
       SuperscriptBox["x", "2"], "-", 
       RowBox[{"6", "x"}], "+", "2"}]], 
     RowBox[{
     "\[DifferentialD]", Cell[
      "x",ExpressionUUID->"92e4fbc6-5416-4d23-9bc5-7e541881e8fa"]}]}],
    FontSize->24]}]],ExpressionUUID->"a80548a2-ef17-4e11-8dbe-db44ef02c4a9"],
 "."
}], "Text",
 CellChangeTimes->{{3.7132363135506687`*^9, 3.713236316382722*^9}, 
   3.7132363828816257`*^9, {3.71323647404787*^9, 3.7132365234540377`*^9}, {
   3.713461784299481*^9, 3.71346178429998*^9}, {3.7134676414066696`*^9, 
   3.7134676617863455`*^9}, {3.7134677873763742`*^9, 
   3.7134677873763742`*^9}, {3.7134679124490924`*^9, 
   3.7134679124490924`*^9}},ExpressionUUID->"8606eac9-7150-49df-a653-\
2bf09a893c5d"],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.7135500275420446`*^9, 
  3.7135500284134684`*^9}},ExpressionUUID->"a0024bbf-6968-495d-8848-\
aabf4d6670f4"],

Cell[TextData[{
 "This is done by ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "e0c7ca7a-6f21-4e2b-818c-1bf6e0cdc89b"],
 "-substitution. Let ",
 Cell[BoxData[
  FormBox[
   RowBox[{"u", "=", 
    RowBox[{
     SuperscriptBox["x", "2"], "-", 
     RowBox[{"6", "x"}], "+", "2"}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "5c8dec34-665c-4645-9f4c-69ef0a5a8065"],
 ", then ",
 Cell[BoxData[
  FormBox[
   RowBox[{"du", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", "x"}], "-", "6"}], ")"}], "dx"}], " ", "=", " ", 
     RowBox[{"2", 
      RowBox[{"(", 
       RowBox[{"x", "-", "3"}], ")"}], "dx"}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "d9e32e8c-ddd8-4132-96a3-508e5232b5d9"],
 ". So ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "3"}], ")"}], "dx"}], "=", 
    RowBox[{
     FractionBox["1", "2"], "du"}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "e5159688-cb57-4c43-803c-206c669f2ece"],
 " and we plug that into the integral"
}], "Text",
 CellChangeTimes->{{3.7132363135506687`*^9, 3.713236316382722*^9}, {
  3.713550964903431*^9, 3.7135510227043824`*^9}, {3.7135540675759726`*^9, 
  3.7135541060546565`*^9}},ExpressionUUID->"b918045e-d2ad-4329-94b4-\
87dc5cfdcb38"],

Cell[TextData[Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"x", "-", "3"}], 
      RowBox[{
       SuperscriptBox["x", "2"], "-", 
       RowBox[{"6", "x"}], "+", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], "=", 
   RowBox[{
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       RowBox[{"1", "/", "2"}], "u"], 
      RowBox[{"\[DifferentialD]", "u"}]}]}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{
       FractionBox["1", "2"], "ln"}], "|", "u", "|", 
      RowBox[{"+", "C"}]}], "=", 
     RowBox[{
      RowBox[{
       FractionBox["1", "2"], "ln"}], "|", 
      RowBox[{
       SuperscriptBox["x", "2"], "-", 
       RowBox[{"6", "x"}], "+", "2"}], "|", 
      RowBox[{"+", "C"}]}]}]}]}],
  FontSize->
   24]],ExpressionUUID->"c092a81a-dace-4a9b-951b-1e1675b21dd6"]], "Text",
 CellChangeTimes->{{3.7132363135506687`*^9, 3.713236316382722*^9}, {
  3.713550964903431*^9, 3.7135510227043824`*^9}, {3.7135540675759726`*^9, 
  3.7135542260445194`*^9}},
 TextAlignment->Center,ExpressionUUID->"bfed83b4-0f3f-4eaa-a12d-b4d2b5e8b292"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 5", "Section",
 CellChangeTimes->{{3.7132360117278037`*^9, 3.7132360131111164`*^9}, 
   3.713236527279331*^9},ExpressionUUID->"8a849707-7d64-4ab6-84bd-\
d2ca7003e56a"],

Cell[TextData[{
 "Find the antiderivative of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", 
     RowBox[{"(", "x", ")"}]}], "=", 
    RowBox[{"x", " ", 
     RowBox[{"cos", "(", 
      SuperscriptBox["x", "2"], ")"}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "02eb462e-0d8d-415c-a9f5-14fbabcc36a9"],
 "."
}], "Text",
 CellChangeTimes->{{3.7132365476937985`*^9, 
  3.713236605121499*^9}},ExpressionUUID->"bb663dc5-2dea-42b5-a721-\
caf63f5372bf"],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.713550033757777*^9, 
  3.71355003491817*^9}},ExpressionUUID->"1cf78d96-98ff-49c5-8ddf-\
ae82b8745566"],

Cell[TextData[{
 "This is also a ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "7ac6ed41-7d7c-4825-a9ed-bf75b054390d"],
 "-substitution problem. Let ",
 Cell[BoxData[
  FormBox[
   RowBox[{"u", "=", 
    SuperscriptBox["x", "2"]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "d33ddda1-83ae-488e-81da-84d490fdd8ef"],
 ", then ",
 Cell[BoxData[
  FormBox[
   RowBox[{"du", "=", 
    RowBox[{"2", "x", " ", "dx"}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "d501dab2-7478-41ff-bbb9-ea3e398ecd94"],
 " and we have"
}], "Text",
 CellChangeTimes->{{3.7132365476937985`*^9, 3.713236598407658*^9}, {
  3.71355425039606*^9, 
  3.713554306134819*^9}},ExpressionUUID->"59934208-d55a-4da0-ae82-\
596e000d13bd"],

Cell[TextData[Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{"xcos", 
    RowBox[{"(", 
     SuperscriptBox["x", "2"], ")"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "=", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], 
    RowBox[{"\[Integral]", 
     RowBox[{"cos", 
      RowBox[{"(", "u", ")"}], 
      RowBox[{"\[DifferentialD]", "u"}]}]}]}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], "sin", 
      RowBox[{"(", "u", ")"}]}], "+", "C"}], "=", 
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], "sin", 
      RowBox[{"(", 
       SuperscriptBox["x", "2"], ")"}]}], "+", "C"}]}]}]}]],
 FontSize->18,ExpressionUUID->"d186da86-03d5-4199-a9ba-604b132d442f"]], "Text",
 CellChangeTimes->{{3.7132365476937985`*^9, 3.713236598407658*^9}, {
  3.71355425039606*^9, 3.7135543881117887`*^9}},
 TextAlignment->Center,ExpressionUUID->"5b86ced5-3a2d-4740-afb8-ebaad4ceee1c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 6", "Section",
 CellChangeTimes->{{3.71323602223969*^9, 
  3.713236023623618*^9}},ExpressionUUID->"9b176684-111d-4f29-bacc-\
264336849fa2"],

Cell[TextData[{
 "Describe the region in the first quadrant which is bounded by the circles ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"]}], "=", "2"}], TraditionalForm]],
  ExpressionUUID->"8d7854f0-714c-4ff0-93ae-9f005261c168"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"]}], "=", "4"}], TraditionalForm]],
  ExpressionUUID->"fd36c845-69c2-4173-9d62-808bf9559615"],
 ", and the lines ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", "x"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "251286a4-215b-409c-ad90-97f0a515e68c"],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    RowBox[{"2", "x"}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "80c7c214-217b-4cc8-b31b-66d02b10df4f"],
 " using polar coordinates."
}], "Text",
 CellChangeTimes->{{3.71323665278123*^9, 3.713236767453306*^9}, {
  3.7134677776202555`*^9, 
  3.713467782061041*^9}},ExpressionUUID->"39594a9e-f325-4236-abf3-\
e2f0761de3dd"],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.713550040085786*^9, 
  3.713550040909877*^9}},ExpressionUUID->"8e9dfb86-620e-4ff0-b2d9-\
053a9d27e359"],

Cell[TextData[{
 "To convert Cartesian coordinates to polar coordinates, we use ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"x", "=", 
     RowBox[{"r", " ", "cos\[Theta]"}]}], ",", " ", 
    RowBox[{"y", "=", 
     RowBox[{"r", " ", "sin\[Theta]"}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "89dc59ef-912d-4f00-8e1a-ec843d5dc40d"],
 ". This means that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"]}], "=", 
    SuperscriptBox["r", "2"]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "887932b2-65d9-4014-92e5-656f3efcefa1"],
 ". ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "b462e647-2579-484f-a09e-245209cb200e"],
 " measures the distance from the origin and \[Theta] measures the angle from \
the positive ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "13f5ebbf-51cc-47b3-9e5f-7ba896dc4662"],
 "-axis (measured between ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "548ac647-d904-41ac-b702-dc6979a188fd"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", "\[Pi]"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "a9b9f3f5-8212-40ea-a78d-480bcc5a5355"],
 ")."
}], "Text",
 CellChangeTimes->{{3.713236683933665*^9, 3.7132366847258434`*^9}, {
  3.713554446086311*^9, 3.713554556621795*^9}, {3.713555667478568*^9, 
  3.713555795020953*^9}},ExpressionUUID->"6101bce0-37e5-49cc-ae58-\
dc5c113256f4"],

Cell[TextData[Cell[BoxData[GridBox[{
   {
    RowBox[{"Cartesian", " ", "Coordinates"}], 
    RowBox[{"Polar", " ", "Coordinates"}]},
   {
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"]}], "=", "2"}], 
    RowBox[{"r", "=", 
     SqrtBox["2"]}]},
   {
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"]}], "=", "4"}], 
    RowBox[{"r", "=", "2"}]},
   {
    RowBox[{"y", "=", "x"}], 
    RowBox[{"\[Theta]", "=", 
     FractionBox["\[Pi]", "4"]}]},
   {
    RowBox[{"y", "=", 
     RowBox[{"2", "x"}]}], 
    RowBox[{"\[Theta]", "=", 
     RowBox[{"arctan", 
      RowBox[{"(", "2", ")"}]}]}]}
  },
  GridBoxDividers->{
   "Columns" -> {False, {True}, False}, "ColumnsIndexed" -> {}, 
    "Rows" -> {False, {True}, False}, 
    "RowsIndexed" -> \
{}}]],ExpressionUUID->"cc4f8b88-7813-4ab0-b56e-f16475142161"]], "Text",
 CellChangeTimes->{{3.713236683933665*^9, 3.7132366847258434`*^9}, {
   3.713554446086311*^9, 3.713554556621795*^9}, {3.713555667478568*^9, 
   3.713555767867998*^9}, {3.713555804972475*^9, 3.7135558559308367`*^9}, 
   3.7135559160455284`*^9, {3.7135559562601147`*^9, 3.7135559867701826`*^9}, {
   3.71355669762177*^9, 3.713556699271422*^9}},
 TextAlignment->Center,ExpressionUUID->"212b731e-ad61-44b0-b7d3-14582063c682"],

Cell[TextData[{
 "So, we can describe this region in polar coordinates by: ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"r", ",", "\[Theta]"}], ")"}], "|", 
      RowBox[{
       SqrtBox["2"], "\[LessEqual]", " ", "r", " ", "\[LessEqual]", " ", 
       "2"}]}], ",", 
     RowBox[{
      FractionBox["\[Pi]", "4"], "\[LessEqual]", " ", "\[Theta]", " ", 
      "\[LessEqual]", " ", 
      RowBox[{"arctan", "(", "2", ")"}]}]}], "}"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "b539ca7c-be93-4853-adde-fd326f4177b7"],
 ". Below is a graph of the region (I\[CloseCurlyQuote]ve left in the \
Mathematica code for what I\[CloseCurlyQuote]ve plotted below):"
}], "Text",
 CellChangeTimes->{{3.713236683933665*^9, 3.7132366847258434`*^9}, {
   3.713554446086311*^9, 3.713554556621795*^9}, {3.713555667478568*^9, 
   3.713555767867998*^9}, {3.713555804972475*^9, 3.7135558559308367`*^9}, 
   3.7135559160455284`*^9, {3.7135559562601147`*^9, 3.713556098519587*^9}, {
   3.713556709288892*^9, 3.713556709288892*^9}, {3.713557047111458*^9, 
   3.7135570784000764`*^9}},ExpressionUUID->"a1de7615-f39f-4d1d-b1a6-\
dbe2ba20b447"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SqrtBox["2"], 
        RowBox[{"Cos", "[", "t", "]"}]}], ",", 
       RowBox[{
        SqrtBox["2"], 
        RowBox[{"Sin", "[", "t", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"\[Pi]", "/", "4"}], ",", 
       RowBox[{"ArcTan", "[", "2", "]"}]}], "}"}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "2"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}], ",", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"2", 
        RowBox[{"Cos", "[", "t", "]"}]}], ",", 
       RowBox[{"2", 
        RowBox[{"Sin", "[", "t", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"\[Pi]", "/", "4"}], ",", 
       RowBox[{"ArcTan", "[", "2", "]"}]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SqrtBox["2"], 
        RowBox[{"Cos", "[", "t", "]"}]}], ",", 
       RowBox[{
        SqrtBox["2"], 
        RowBox[{"Sin", "[", "t", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"\[Pi]", "/", "4"}]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Gray", ",", 
        RowBox[{"Opacity", "[", "0.5", "]"}]}], "}"}]}]}], "]"}], ",", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"2", 
        RowBox[{"Cos", "[", "t", "]"}]}], ",", 
       RowBox[{"2", 
        RowBox[{"Sin", "[", "t", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"\[Pi]", "/", "4"}]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Gray", ",", 
        RowBox[{"Opacity", "[", "0.5", "]"}]}], "}"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SqrtBox["2"], 
        RowBox[{"Cos", "[", "t", "]"}]}], ",", 
       RowBox[{
        SqrtBox["2"], 
        RowBox[{"Sin", "[", "t", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"ArcTan", "[", "2", "]"}], ",", 
       RowBox[{"\[Pi]", "/", "2"}]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Gray", ",", 
        RowBox[{"Opacity", "[", "0.5", "]"}]}], "}"}]}]}], "]"}], ",", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"2", 
        RowBox[{"Cos", "[", "t", "]"}]}], ",", 
       RowBox[{"2", 
        RowBox[{"Sin", "[", "t", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"ArcTan", "[", "2", "]"}], ",", 
       RowBox[{"\[Pi]", "/", "2"}]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Gray", ",", 
        RowBox[{"Opacity", "[", "0.5", "]"}]}], "}"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t", ",", "t"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "1", ",", 
       SqrtBox["2"]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"2", "t"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       SqrtBox[
        FractionBox["2", "5"]], ",", 
       RowBox[{"2", "/", 
        SqrtBox["5"]}]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t", ",", "t"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Gray", ",", 
        RowBox[{"Opacity", "[", "0.5", "]"}]}], "}"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"2", "t"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       SqrtBox[
        FractionBox["2", "5"]]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Gray", ",", 
        RowBox[{"Opacity", "[", "0.5", "]"}]}], "}"}]}]}], "]"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.7135561260222235`*^9, 3.7135561277091804`*^9}, {
  3.713556188227778*^9, 3.713556272117443*^9}, {3.7135563058234386`*^9, 
  3.7135563435455513`*^9}, {3.7135563741020927`*^9, 3.7135564082065835`*^9}, {
  3.7135564399101195`*^9, 3.713556444569748*^9}, {3.7135564823543*^9, 
  3.7135566265345325`*^9}, {3.7135566609856906`*^9, 3.7135566819722705`*^9}, {
  3.7135567296805835`*^9, 
  3.7135570116156635`*^9}},ExpressionUUID->"f6bdad0b-a1d6-456b-a04a-\
c7868deaae4c"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.], 
      FaceForm[Opacity[0.3]], LineBox[CompressedData["
1:eJw1zAtMU3cUBnAKFWIByyjo8AETrU4nTOVNXT+clGgT3psCPkAE7IDIQAWd
oCgCPpg4QRGpgDrmhKAhohBlzokDRRRFgZCwBfRPaWlLb++9ViHY7bpkJzn5
8st5LEzMiEq2tLCwCOX6Y/IsPhaF/3OLRiNY9Y8BL/7W5+zkXFxV6ZBoNiAg
X6p/xrlgRG73cNoAn06b5xd5FDyvvn9YPGlAU4l/tsSKgldztWQWY8CgB1+W
bU1h0SAPc1QGFNc+1WrsKBBJaZ1LtwE1afvjHrtQeMVf0Z9TZsCHocj0Uz4U
slav9sQ2A1IHWzLCwyms2czzv7/MAJt5d24nKSi4ZJ45vJuaQFxtxb7UAgr6
Q+fFdXcmYDJ3Zu1VUogcyRJMHZqAvdzUsLOFgm8yIfwQbl7gfvPaCwpHF/2h
uCKcwA7r1oYpDQXv8xeCol/pobOOnrOUb4QvaWu7pNRj5cP18TvnG+ERWy5u
S9ZDcFIs53kbsf/zlL7+ZXowebPNqaFGhFqly3826tA6e1ccnWTE9DJb+6Rm
HbZXuI/joBFtYdM5uhwdZhh2lL8+x+1XpA5KoEO++Ya4sZGb1x4fS+fpMPeY
ZfOqDiOC1418m9GpxcUpWeybISPq2x2EIce0OH6iyk321oj0jTqVYYMWQQMC
ymxHQzopuntQqIWTRdQeyp2G5SHt9IuecYSry08VBtLI5rvHOZWPIzDC9rdN
ETTc7VqcpbHjOJmmuFWSTMPqbqpkgcs4pPNsSUwujTS6c+zDkAaNpc5d6T/R
eCn9pqm4SoMN/L679r/SiH73S7wpTgPFrJZuu3s09JHh0/tcNag+HdSwrZfG
llw3v3NDatxMjrq+Uk1D6PnD6+fVagRsXO66eZpGPO/aPqtENcQHCsYnhAxm
xAgt293UOFiWIDYtZvDu0+teTSNjMPEcRxL8GZRVtC9ZWD2GW7Z/VXqHMvAw
rWUebRtDUZBjTWYCgyJBf0fmZ2OY3Pt93bzdDHq9qnJLh1QQ6Gc0LCxmUDdQ
UPtWqYIozX+HspLBYifn+R2bVAiLvLBL0cjgvWIje1akgkP9xG3lfQZJbVTL
vZejuBzVfCKyl8Fep+FS2alRJJmDV8tHGYiODw15hI6iz3VS8djEwDz/TtUS
+1GEZfi9abNhMZb63pTZSZAY/USrcmHhXRbs7FlE0H0kP/TKchZPrrp6CgoJ
BtOYUj1nH17H16oCgpSZIc/8vmCRk5kXX32YQCo+Ie3mLH5+NmVWHkGPb4me
XcHC3F3boN9NsP1AaqHsSxaPlj5wvLadIKRIrHzjxWJpTWvd0QSC6kuZcR7e
3P9XBd4J8QQ2P1Y55XBuSqmUzdlK0FpxLFfgw+Jya6dPYQxBVv+fc1f5cvcZ
yWEJ4QTDXb+fzvNnIexpr5aEEYgGRuw6OcfWT43PDiVIejB81CGARc0DOvup
nCB4ao/iCme1tWhrYAhBhPzth0eBLPqfSUqcZQRd9dMxjhIWEUZpC7WOIDBr
+MZmzmd9+iyuriWYmlwTOcHZq0fhdiSIQK68VeW3hsXMmwMBW0Fw5jvB63zO
/AXuEf5Sgt4oyeIuzp9sWJ8o+opA+F+y+BfIjGZu
       "]]},
     Annotation[#, "Charting`Private`Tag$13942#1"]& ]}, {{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.], 
      FaceForm[Opacity[0.3]], LineBox[CompressedData["
1:eJw1zHk41AkAxvHZiFLPrtXGttViiNqkgxQ2r0glsgqFttL05KiWLTTj6FFq
GotyJo0ckYqOp4Z2bM8kuVJ2LGltuRqttsNvmPM31y92dp+nP97n+3z+ea0Z
cdsPTKPRaFv1+69C97TIsgoSn/rEweWL2frSJHPvr7hMQtTvVp9UTiJ1pXZm
i9464TJ5cBmJOqq27G0liaJbgg2zLpGQmd8oWVFNInl9gQvzAgl2vOnooxoS
J4I7Q/zPkdhS13FrhEeCelPNGUsh8U1qg6V5GwmbQ3eMRUEkOk6KhnYRJLoK
kqXrHElk3avufGyqQo1RzhLLmSSu8Pb1ezqrMC1A0s0VKeH41sSEFa7CtdC8
V+fuK1Fn1cR5fVyFrkmy2SxPiaklERaTVSq0O7EDLaKVSJCwkqyeqHCkOXdH
1XolnPn896fGVNjTVHCaZ6HEyJopAcdUjSbrmvFAiQKP+vrye1epYWA8Oyvt
iQILF3PpzsFqcH1feS4qV4CZWlVky1Ijfzg2NpqpQGSr3buDF9XIm/6i92t/
BcynD+Y4PVCDirRdsNNagWVnT2SYiNTQCWJs1mvkSDlWPOBD04D6cKQiWyhH
ulsBZHQNRunRrllX5NjtLgky8dYg6NKdnhGmHJWSdg77gAbRTx/whH5yVLlF
Oc3haCDpiz+bTJejI/Ju3vyrGvSEdS9PUMqQy/LbnvhYg4NraYrVnTI8cjeK
2PaPBgtWMLaXXJbBv9dh3g+GWriUcvu9EmRwXdNTn22rRYbPUOZDXxk+sh9f
3+WlRenCYF7ifBnmZ1799keGFv0b1XVCsRTzBn2vMk9q4ZoQMGLcIsXmCbqz
c5kWz8aafI4USuEpTDM0faCFeNgmpyVaCn6kX1fhSy3CpsLs2tZJ0RxhlrNB
qYXVYPYW4nMp2i2PF382R4epvftPzPhbgs2RVhuZjjrIPvSEetVJ4HG7nDnm
p8Np0Ytm5hkJwgRH06yidOhL6h9jhEtgc8qtmn1Sh2300FLGdxJs4O6a6CvV
wefnbqde7QQavm9z1PB1kO8pCdEVT+BN7ECyuleHVVE7udlrJ3DT0MveekIH
ifP7du/hcQyXTstcOoPClCOr1SB1HCnL219P0SnE2X8QKC3HcXtNWHyjO4WP
N8S0mDYxir2NIvlBFDbtGxp6zhDD9U/tL1E/UeBXF4ZnGIlhx36eZ8am4OcY
lzlmKMYFx9qiFL0ru8PqAwzEOGxYe35U7zP1EeRXNDFCXtmn/3qGwl4XD6fL
GgJy9by54RkUWKbpuQ0EAaGylV6RReFOV+rA62cEVi+uGLTPp3B06+RWnx4C
x/ry7HL1tmdy71/7g4Ch4Y2Dar1FC23TD/9OgMcJGukooDBLy36qbCMQNpic
EXOeAj4KPY1/I9BgbtpYU0wh8y/rkBg+gQxBXO2XFyksu3Z+f+c9AqPZytwk
vT2ShmNzeARcQ+P9fbkU7BwmPSxuEkjcuPr4uxIKLYpw26RaAvfELW6Blyjs
Du03GLhOoHAuS8bXO9Hb625ZNYGA/MBATimFQwlL02hXCAgECeS43gEFazcx
KglIzBqLdpRRGFbEzGyt0P+lOaxs1HtA/LBtUTmBl/+Xwr8aJJaA
       "]]},
     Annotation[#, "Charting`Private`Tag$13965#1"]& ]}, {{}, {}, 
    TagBox[
     {GrayLevel[0.5], AbsoluteThickness[1.6], Opacity[0.5], 
      LineBox[CompressedData["
1:eJw91nk01tkfB3ARLRQmJVnKmsxoMoNCeg9RE5nIlK2SJY1Hxr4TIWR5JvuS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       "]]},
     Annotation[#, "Charting`Private`Tag$13988#1"]& ]}, {{}, {}, 
    TagBox[
     {GrayLevel[0.5], AbsoluteThickness[1.6], Opacity[0.5], 
      LineBox[CompressedData["
1:eJxF1Ak0lXkfB3DUSJFKtHlRo1Bo06ihfJGRGrK8YWIsoWS/loykRMqWkr10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       "]]},
     Annotation[#, "Charting`Private`Tag$14011#1"]& ]}, {{}, {}, 
    TagBox[
     {GrayLevel[0.5], AbsoluteThickness[1.6], Opacity[0.5], 
      LineBox[CompressedData["
1:eJwd1Hk01fkbB3AxihEVg5pGGJpprBlJ3Hg3luwkUbIkI0sllbVruYwo+3KT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       "]]},
     Annotation[#, "Charting`Private`Tag$14034#1"]& ]}, {{}, {}, 
    TagBox[
     {GrayLevel[0.5], AbsoluteThickness[1.6], Opacity[0.5], 
      LineBox[CompressedData["
1:eJwl1Xk41dkfB3BRKdQvS5sIMSpbttEYy9uISpFqGjSWsk+urQ2ljZQrJdmi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       "]]},
     Annotation[#, "Charting`Private`Tag$14057#1"]& ]}, {{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.], 
      FaceForm[Opacity[0.3]], LineBox[CompressedData["
1:eJxNxWlI0wEAhnG3Rh40j+mgD85NBUP9MgIn4fQ/dYPZWM3UbCPyYDqPoaFJ
qNsqWCSb2Wqhq6XzKEkzWZKktUzosEBZBdkkmWBJHuU9I5tYEe3dAw+/yMLK
Y0VkHx8f8Z//+q9V4r/sQmPCRS/zX8SUB5DgswbxZBgZakLMfbEUuBPFkWb5
wW2BcqA7GLr0Drk4EhboP80pBDDrqHWRoYDhNGZ3XAM8KRxSU/pgVHr0VO0E
zHswJLGtweqIeU0Ofc0jVbLA1nFghCtsVy+Dg6dombEqGD3WI2W0Qr+uco1z
FFan78YkzcKc3KdL8r3rHgPL6Iq5WChOJYpJIrin0XhhsQIS5mFWpQGuMwKm
Rx9ClWVTXOqAjXPW9Ps/YailJWeEseGRxZAslRGQcrMzsSIf5umY7SlayCMq
GnvvQJPi6/XPb+BY03ZW9Xeoqptpbgvc9Hh3atnVfBDKduyOuGw4yxRV0Wu8
HFw9MGGCJcElBazHsMjp/4jnhPOn1Qb3Lkwl61lBkS6PNN/n48t8WPp23F1a
DBOppIwBHZwW2kWZ/dA3o/K93g57bIdqjBvw3eYHM4e+5dEev6+WzYGCSWXV
DylMFVhWpPUw/GUdacXLLf7xUK0K9vKpif1qSOPXa8jn4Ze0XOo9LbzEC4p3
X4aFo4vcq02Qy3t1JOYKXCXUVRIDPEEsDd++BuNSxoTiFkgZ6ZTNeulM1ijP
mqAxOcHQcQO6uV0fXWY4adMs6G5BK1f2i9kK5dwQ5uE2mGL7xp7xcj/3ddoZ
C1x/0pXt3w4nks4Vt3n5G9ONa2M=
       "]]},
     Annotation[#, "Charting`Private`Tag$14080#1"]& ]}, {{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.], 
      FaceForm[Opacity[0.3]], LineBox[CompressedData["
1:eJwty39szHccx/FOxOaohvpRUdmQDtnQwyp+vvwuE7RmLVHFTXFSv6qkTaUr
kh6lq9DS+lUkM5ayTWqLNbvLVFWkmx+pihNy5Xvf+/XR+PHt3X3vPn6c3OuP
dx555pX3ENOWJTldYmJiFkbuo3Hz55nipyqIquHwcGt7Q6SjaujfbfyatdMU
qiGx8fPVV6FQDSOmBlZmzlSohunG88tPpCpUQ97ArunDlihUQ5vHhnHrFarB
2NhifFqpUA1js86s22NTqIZWy4+FaR6FajCIN2cu9nfSTqhxY3rI6U7aiYzc
9/sfbXbSTqxb8Vh1nHDSTiQaikvbm5w0sr+6OmnTGyeN/FfXG18PVqkfrnvW
bmdTVepHz9nZL+35KvXj4Y4bib1qVepHisO2sqVFpX588+TmrnpdpX7Yayqf
Vg1z0QDiKwJLu6S7aACvZw3ptaHIRQPIMToeL7voogEU/PGrZXubiwYw9tXk
nZYYNw2ixGwq/HK0mwaRf3axzbrMTYP4LHfe85I9bhpE8pa2Qf//5qZBvDN+
dayv3U2DWD2q33D1Uw/VYWowVLWP91Adhu7Nc9qyPVTH3IqEHhkHPVTHyAfJ
8Xf+9FAddZeW6tscHqqj0Rqr1cZ6aQglFeXG5gleGsK96nN7C3O8NIRba4oT
kg55aQir/sk5ELrmpSGUpT/rs8LlpSFk/Zz0pL63j4Zx3fiuoQY+GsattGcF
F3J9NIz8MeUFvx/10TDq5/53cNYNHw3j+ODW53c6fDSMLyxqQmmCoBKTRv5k
ap4jqESoTHZ8slVQidLqzGJrpKNK9D5/JbZom6ASI/7d8LWWJ6hERqDVrO4Q
VOLKD5eU20WCSmyckm0/YhFUwj//mjltn6ASuzP76j33CypRnXd7QGmZoBI3
L6R8X1AuqMTQfnF3s44IKnF56MZVAysFlZiY3NTxINJRJdIWFMUuPiqoRPFu
17czagSVMFTMtL+NdFSJqpOnzH8fF1Si7q/v9o07KajEhKbLA15GOqrE9fvd
f6k7JajEIsfaFPNpQSUevbA1JdUKKvEBl16BsQ==
       "]]},
     Annotation[#, "Charting`Private`Tag$14103#1"]& ]}, {{}, {}, 
    TagBox[
     {GrayLevel[0.5], AbsoluteThickness[1.6], Opacity[0.5], 
      LineBox[CompressedData["
1:eJxd1GtL0wEYxuFtYp7SUmIyQ2G5pPUiJQOpjGqIWrpoUzuAWR4K/4Gl6BSj
kZp2XLXUWpCK6Jy2zBJ8UWo2nawta9Mt25qyPKzNrTUNh5m2qAieh3bDj+sb
3PSc89zTFBKJxP7TXz2Xs0pVXaXt2Pu/CR6me5jnYYmH1R7WgypuGmnhmxjk
L8c+SYx4CprYSXflN3vAmJFaq8j1Ahx9dvYKmfwKDMkubNbED4ERNtX8Mccw
yGkjZjsLXoNZZQZz2OY3YC3/1o20rrfgFq/sFsVWDcjWkM2PnKMgLW5JOR6j
BbVMbU/QbR0Yn/nyo9n8HuztGDnczPgAMioG1fmX9GBLkbGJKjeAgU4jb4xu
BJlSew3zwgR4vCJ87kzfJMibjuN0h5rAtkze2unMT6A8IJukZ0+B0m2rbvkK
+tAkEUc2TIOUdIXaL2UGZBEF9waWUEFAlLfl/iyYWsxdrkswg9R8YX2PBX3+
M+Nda81ncOzIneu07RZwcY/RSdahAvsDfWGlFYxmEASXMQdK3TIRZRhtaBAc
2FlkA0VKQjwTYgf9enurQobQ9JQ69/pzX8AOgk+vCnKAxewJZXk/mjRwkGbO
+gq61PvXhP9CQ9s6SyelTjDBlykMSp0HI/PmMkyHUIqsfWMXB5WVRbWzj6Lx
1sgBQQ4aq4hw+Jejm6o3JPtIUPKULlDfgU7trtNJHqNNi8EnE7vRsNx1pTX9
aDDLX+ylQxcaVYRuHFX/uBbdakAF3T59LBPqS/fWVtpQ68VhEceBKgyXT9Dn
0WohxSZzobmOwS7hd5SVXFlyagWli/ftinGj/15rAfwNhBBtmQ==
       "]]},
     Annotation[#, "Charting`Private`Tag$14126#1"]& ]}, {{}, {}, 
    TagBox[
     {GrayLevel[0.5], AbsoluteThickness[1.6], Opacity[0.5], 
      LineBox[CompressedData["
1:eJxdxX1I1HcAx3HnJnMlzZQZhEV6RqUSUcsHeviQmuhIayaBhctdWSZFshhm
W5YUqdHSKNbmtK45RhqEUprezjiS7XrwnHp6Pud5v29dqeXd/b5JVNoDff66
N7x5hWgPpmV7e3l5pbz/g569bbfkVu9fho/GepjsYYaH+zws8LDUw9/hUL5r
3VlYQWth0RUbtlyvpjeQsjBrVeh0DW3GgkCM5+TWUSP2TRr+Nv9xg7bCWZ55
+MrcW9SE1oyZiyn5enofE69+uXLqzxZqxtUVuqx5pUbaAZ+OvEf1mju0C74n
NpyLaWylFlz9TXN3Kvdf2oND86cP/eRtor0YnHHURhvu0j6MTXX52g7cpwMI
29EwmOrdRofwOqQm9kWTmQ5jOv2CnzbtfzqC1B+TVn9a3EFtcN37L/9BVicd
RW23UU5FdFE76svjo9f7WqiCdu+4m096LFTB7UJjQunlbirw5pqpYuORHvoI
W8q+ichOtNLHcGu2Fek0vdSBnDujY51veqkDatDTs3tMffQJzMEFL4Oq++lT
GPpOVobnDdAxFF7yT/86dpCOo+yrxZ0ZgUN0Ag1xDSX2h0N0AuEh7T7F/wzT
Z7jZoG05W/qQPkdAen7Jma0jdBIj35722zrPRp0wdgf9cO6ojTqRVLdXnzlh
o07oyw/7Lc4YpS5EbTK9rro9Sl3YnjVg/ivSTt0o2RyxLvO8nbqhi1/b6P/S
Tt3YWT43IC1boSqWNYXN3vhAoSr2JxYl+JkVqqKue/iopV2hKmJcvzq/71Ko
isTwL6yF/QpVoa18pmtyKFRF5fHGqMjPBJWwzQnMU30EldBUHazRfy6oRG3z
0uDk2YJKNLsrPtkTIKiEdfextsuLBJWYrw767A0VVCKzKAbLwwSVEFWuesMS
QSXc1l0X+5cLKhGVbezQrRBUokANnpWzUlAJL3/rz1OrBZVIuLSysSVaUImS
yLLJk7GCSrTpx5duWiOoxJfJSdrAdYJKvAOUC3hr
       "]]},
     Annotation[#, "Charting`Private`Tag$14149#1"]& ]}},
  AspectRatio->{1, 1},
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{"ScalingFunctions" -> None},
  PlotRange->{{0, 2}, {0, 2}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.7135565406274095`*^9, 3.713556562096044*^9}, 
   3.713556593724262*^9, 3.713556627867361*^9, {3.713556663436393*^9, 
   3.713556682628292*^9}, {3.71355677097406*^9, 3.7135568008612905`*^9}, 
   3.7135568928836737`*^9, 3.7135569824664793`*^9, 
   3.7135570127215223`*^9},ExpressionUUID->"02eca5f1-4325-489e-ba09-\
9c281172b488"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 7", "Section",
 CellChangeTimes->{{3.713236026463976*^9, 
  3.7132360275922284`*^9}},ExpressionUUID->"213b8a14-dd5d-4c8b-839d-\
d0746db10921"],

Cell[TextData[{
 "Compute the integral ",
 Cell[BoxData[
  RowBox[{
   StyleBox[
    SubsuperscriptBox["\[Integral]", Cell[
     "0",ExpressionUUID->"da192779-d8b6-436d-9f4b-a18f2e208428"], "\[Pi]"],
    FontSize->24], 
   RowBox[{
    SuperscriptBox["sin", "3"], "\[Theta]", 
    RowBox[{"\[DifferentialD]", "\[Theta]"}]}]}]],ExpressionUUID->
  "cad6f63d-4a65-40ac-9b06-2d0f3f9fea3c"],
 "."
}], "Text",
 CellChangeTimes->{{3.7132367787251453`*^9, 3.7132368234142118`*^9}, 
   3.713236878664731*^9, {3.713468976067685*^9, 
   3.713468976067685*^9}},ExpressionUUID->"140bdf55-ab75-4f74-9e26-\
7f21c5377a32"],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.7135500450536413`*^9, 3.713550046313799*^9}, 
   3.713557925884309*^9},ExpressionUUID->"499dc021-5c16-439c-9cc9-\
e4c4a155f0a6"],

Cell[TextData[{
 "First, we rewrite the integrand using trig identities (in this case ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["sin", "2"], "\[Theta]"}], " ", "+", " ", 
     RowBox[{
      SuperscriptBox["cos", "2"], "\[Theta]"}]}], "=", "1"}], 
   TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "30ed5b09-7873-48ab-8b9c-d33b62853995"],
 ") in a form that can be hit with ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "cd6da69f-c9ba-48c0-97a5-74b9dae18980"],
 "-substitution:"
}], "Text",
 CellChangeTimes->{{3.7135579377063265`*^9, 
  3.713558021050889*^9}},ExpressionUUID->"7d9b52a3-2b67-47a3-a7c3-\
bbc9c69dac8a"],

Cell[TextData[Cell[BoxData[
 RowBox[{
  RowBox[{
   SubsuperscriptBox["\[Integral]", "0", "\[Pi]"], 
   RowBox[{
    SuperscriptBox["sin", "3"], "\[Theta]", 
    RowBox[{"\[DifferentialD]", "\[Theta]"}]}]}], "\[AlignmentMarker]", "=", 
  RowBox[{
   RowBox[{
    SubsuperscriptBox["\[Integral]", "0", "\[Pi]"], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"sin", " ", "\[Theta]"}], ")"}], 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["sin", "2"], "\[Theta]"}], ")"}], 
     RowBox[{"\[DifferentialD]", "\[Theta]"}]}]}], "=", 
   RowBox[{
    SubsuperscriptBox["\[Integral]", "0", "\[Pi]"], 
    RowBox[{"sin", " ", "\[Theta]", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{
        SuperscriptBox["cos", "2"], "\[Theta]"}]}], ")"}], 
     RowBox[{"\[DifferentialD]", "\[Theta]"}]}]}]}]}]],
 FontSize->18,ExpressionUUID->"c844d9d0-7160-48db-b9aa-c1a83df44bfd"]], "Text",
 CellChangeTimes->{{3.7132367787251453`*^9, 3.7132368234142118`*^9}, {
  3.713557699657977*^9, 3.7135578401550446`*^9}, {3.7135579071235375`*^9, 
  3.7135579156461983`*^9}},
 TextAlignment->
  AlignmentMarker,ExpressionUUID->"c7320850-1155-45fb-a479-b0ce8618a311"],

Cell[TextData[{
 "Let ",
 Cell[BoxData[
  FormBox[
   RowBox[{"u", "=", 
    RowBox[{"cos", " ", "\[Theta]"}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "2eeaeb2c-7f98-49cf-ba34-13af5601bcd3"],
 ", then ",
 Cell[BoxData[
  FormBox[
   RowBox[{"du", "=", 
    RowBox[{
     RowBox[{"-", "sin"}], " ", "\[Theta]", " ", "d\[Theta]"}]}], 
   TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "456f1625-033a-486a-9580-9f49a2176812"],
 " so the integral becomes"
}], "Text",
 CellChangeTimes->{{3.713558026478597*^9, 
  3.713558098405088*^9}},ExpressionUUID->"44cfbf50-9cd8-4ccc-b1e9-\
3cd24716653a"],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   SubsuperscriptBox["\[Integral]", "0", "\[Pi]"], 
   RowBox[{"sin", " ", "\[Theta]", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{
       SuperscriptBox["cos", "2"], "\[Theta]"}]}], ")"}], 
    RowBox[{"\[DifferentialD]", "\[Theta]"}]}]}]],
  FontSize->18,ExpressionUUID->"dd8c25b4-63bc-4355-862d-d589cc1a0f5f"],
 StyleBox[" ",
  FontSize->18],
 Cell[BoxData[
  FormBox[
   RowBox[{"=", " ", "-"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "05de2fd6-a0a0-4285-aa7e-b2736af8c4d0"],
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubsuperscriptBox["\[Integral]", "1", 
     RowBox[{"-", "1"}]], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox["u", "2"]}], ")"}], 
     RowBox[{"\[DifferentialD]", "u"}]}]}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{"u", "-", 
        RowBox[{
         FractionBox["1", "3"], 
         SuperscriptBox["u", "3"]}]}], ")"}]}], 
     OverscriptBox[
      UnderscriptBox["|", "1"], 
      RowBox[{"-", "1"}]]}], "=", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          FractionBox["1", "3"]}], ")"}], "-", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          FractionBox["1", "3"]}], ")"}]}], "]"}]}], "=", 
     FractionBox["4", "3"]}]}]}]],
  FontSize->18,ExpressionUUID->"085a3ee8-1656-449a-bb12-249f80def3a1"]
}], "Text",
 CellChangeTimes->{{3.713558026478597*^9, 3.713558191669284*^9}, {
  3.713558226134551*^9, 3.7135582261350374`*^9}, {3.7135583881828365`*^9, 
  3.713558431812442*^9}, {3.71355847811141*^9, 3.713558480436339*^9}, {
  3.713559031279649*^9, 
  3.713559037197695*^9}},ExpressionUUID->"7c12c583-da61-4e5e-b4bb-\
a7ea22912075"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 8", "Section",
 CellChangeTimes->{{3.713236030488112*^9, 
  3.7132360333433156`*^9}},ExpressionUUID->"dae64fe3-d030-402a-99bd-\
33d99c0fb7f0"],

Cell[TextData[{
 "Find the absolute extrema of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", 
     RowBox[{"(", "x", ")"}]}], "=", 
    RowBox[{
     RowBox[{"2", 
      SuperscriptBox["x", "3"]}], "-", 
     RowBox[{"6", "x"}]}]}], TraditionalForm]],ExpressionUUID->
  "95e81c42-8c5d-424c-b8ed-d4391c7bee52"],
 " on the interval ",
 Cell[BoxData[
  FormBox[
   RowBox[{"[", 
    RowBox[{"0", ",", "3"}], "]"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "6863d91e-bc8e-4166-8d9a-7262ff5f8fb3"],
 "."
}], "Text",
 CellChangeTimes->{{3.713236916043934*^9, 3.7132369632722015`*^9}, 
   3.7134689836990843`*^9},ExpressionUUID->"f42c23bc-d166-4763-8758-\
4c71e5ee6cd1"],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.7135500512860665`*^9, 
  3.713550052190031*^9}},ExpressionUUID->"46d59209-ea8b-4d0e-bb40-\
f5fc8cc1ff68"],

Cell[TextData[{
 "First, we find the critical points of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "x", ")"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "95dd17ad-5dd1-46fb-98c0-e737ec90e5a0"],
 ":\n",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"f", "'"}], 
     RowBox[{"(", "x", ")"}]}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"6", 
       SuperscriptBox["x", "2"]}], "-", "6"}], "=", 
     RowBox[{"6", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "-", "1"}], ")"}]}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "f30117c9-0386-454c-991c-cc14cced0699"],
 "\nso the zeros of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "'"}], 
    RowBox[{"(", "x", ")"}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "af78faa2-6a62-48d6-902c-854ce02469d1"],
 " are ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"x", "=", 
     RowBox[{"-", "1"}]}], ",", "1"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "2a5fd767-5bf8-4470-9873-9374a7f74e1c"],
 ". The critical point ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", 
    RowBox[{"-", "1"}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "e715808b-cd42-4fc5-8045-2edac2962e59"],
 " isn\[CloseCurlyQuote]t in the interval ",
 Cell[BoxData[
  FormBox[
   RowBox[{"[", 
    RowBox[{"0", ",", "3"}], "]"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "4be20233-c0ea-471d-8dda-5590d7b1bd2b"],
 ", so we ignore it. Now check the value of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "x", ")"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "e2b455d2-5fe9-4c15-89fb-2171e9d1b220"],
 " at the remaining critical point and endpoints of the interval.\n\n",
 Cell[BoxData[GridBox[{
    {Cell["x",ExpressionUUID->"b0984f58-7371-4668-8c58-e0dd297850ee"], Cell[
     "f(x)",ExpressionUUID->"3f02fe4e-71bd-4328-9fa1-0e85556f5aff"]},
    {Cell[TextData[Cell[BoxData[
      FormBox["0", TraditionalForm]],
      FormatType->"TraditionalForm",ExpressionUUID->
      "5ff0841a-0c91-4be9-bbc4-536e0b22caa0"]],ExpressionUUID->
      "8c85c062-7dd9-4269-a7b4-ca748a64a556"], "0"},
    {Cell["1",ExpressionUUID->"a8fd20a9-e085-4391-92fa-d084f4d26ea5"], 
     RowBox[{"-", "4"}]},
    {Cell["3",ExpressionUUID->"c400ed84-d7ec-4cdd-8917-595791ecf0ee"], "36"}
   },
   GridBoxDividers->{
    "Columns" -> {False, {True}, False}, "ColumnsIndexed" -> {}, 
     "Rows" -> {False, {True}, False}, "RowsIndexed" -> {}}]],ExpressionUUID->
  "e4593906-a652-4ff8-83f1-31fd83538c08"],
 "\n\nFrom the chart above, we can see that the absolute minimum is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "4"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "f469291d-cdad-4c3e-9226-e6e2803098ec"],
 " at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "1"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "27b9f998-97f7-44cd-9e1e-952f9a290bd5"],
 " and the absolute maximum is ",
 Cell[BoxData[
  FormBox["36", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "47e9d8fe-c694-4071-be1a-95eb13567763"],
 " at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "3"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "121c0028-bade-4e4b-a0f8-bd9bc6053ddf"],
 "."
}], "Text",
 CellChangeTimes->{{3.713236916043934*^9, 3.713236958636312*^9}, {
  3.7135585590025244`*^9, 3.713558578182538*^9}, {3.713558647562729*^9, 
  3.713558877044409*^9}, {3.713558933565798*^9, 
  3.7135589960608983`*^9}},ExpressionUUID->"019af7f2-2748-4e87-8b0b-\
edfe03f17335"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"2", 
       RowBox[{"x", "^", "3"}]}], "-", 
      RowBox[{"6", "x"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}], ",", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "t"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"-", "4"}], ",", "36"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Red", ",", "Thin", ",", 
        RowBox[{"Opacity", "[", "0.5", "]"}]}], "}"}]}]}], "]"}], ",", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "t"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"-", "4"}], ",", "36"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Red", ",", "Thin", ",", 
        RowBox[{"Opacity", "[", "0.5", "]"}]}], "}"}]}]}], "]"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.7135590022250166`*^9, 3.7135590144599113`*^9}, {
  3.713559181392528*^9, 
  3.713559269551298*^9}},ExpressionUUID->"01e0dbd4-83fe-4841-b35b-\
b6530c75e686"],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.], 
       LineBox[CompressedData["
1:eJwV1nc8Vf8bAPBrXuveQ0kiQkihYVN5zo1+oqWJiMyspEFGkqRkJaSUEcpK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        "]]},
      Annotation[#, "Charting`Private`Tag$15824#1"]& ]}, {}, {}}, {{}, {}, 
    TagBox[
     {RGBColor[1, 0, 0], Thickness[Tiny], Opacity[0.5], 
      LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQDQEf7CG0wAEYf0fGlBNMd3jg/MKLGhNZd3DC+U5v
Tv8/+YIJzk/mrF+uLvVzP4y/umq2pp7rSzifq/5+bEX+GnsYX6hEdAE762s4
P+qpoRKfwW84/8yxivB7fiwOML6PbIeFwSQuON9sKt+8xHUCcP73Owa5L24K
w/mfnX96VXwVg/Pt21h2rQiRgvP3dKaXiVXJwvkuW9iSJhUqwPkem3UE5OSU
4Pwnk/6lnFirDOdrPChkco5XhfNZ+Ca63fmsBud3rAy87LpKA85fFZL6fHOE
Fpyf8kBlkcMrbTj/2M3WpXPn6sL5BzdP8pc00Yfz1/pVHvBJNIDzfX9V/i2x
NITzLadd6NVhNoLzf74odzpzF8HvOHzCKm+LMZyf3JffNr/GBM4XEkj/tiPU
FM7na9qyM1HBDM6/Ub36AM9zBL9M5/Pr+fvM4fzEsxOyDrVbwPkKqvW8ZxMt
4Xzt3MPM6bpWcD6r7UZb5q8I/ubD72e3n7VG+NeqxXf2dBs4vzojU3l6kS2c
LyH3w2aqpx2cz3jkzkolIXs4f5+CkPWM1wj+k23n+v2iHeD8AMWXypf2Ifhq
z7VPndRyhPOVlkpKdfYj+BMv8fQeOY7gQ2gnBwCWnO0m
       "]]},
     Annotation[#, "Charting`Private`Tag$15862#1"]& ]}, {{}, {}, 
    TagBox[
     {RGBColor[1, 0, 0], Thickness[Tiny], Opacity[0.5], 
      LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQDQEcDhBa4ACMvyNjygmmOzxwfuFFjYmsOzjhfKc3
p/+ffMEE5ydz1i9Xl/q5H8ZfXTVbU8/1JZzPVX8/tiJ/jT2ML1QiuoCd9TWc
H/XUUInP4Decf+ZYRfg9PxYHGN9HtsPCYBIXnG82lW9e4joBOP/7HYPcFzeF
4fzPzj+9Kr6Kwfn2bSy7VoRIwfl7OtPLxKpk4XyXLWxJkwoV4HyPzToCcnJK
cP6TSf9STqxVhvM1HhQyOcerwvksfBPd7nxWg/M7VgZedl2lAeevCkl9vjlC
C85PeaCyyOGVNpx/7Gbr0rlzdeH8g5sn+Uua6MP5a/0qD/gkGsD5vr8q/5ZY
GsL5ltMu9OowG8H5P1+UO525i+B3HD5hlbfFGM5P7stvm19jAucLCaR/2xFq
CufzNW3ZmahgBuffqF59gOc5gl+m8/n1/H3mcH7i2QlZh9ot4HwF1Xres4mW
cL527mHmdF0rOJ/VdqMt81cEf/Ph97Pbz1oj/GvV4jt7ug2cX52RqTy9yBbO
l5D7YTPV0w7OZzxyZ6WSkD2cv09ByHrGawT/ybZz/X7RDnB+gOJL5Uv7EHy1
59qnTmo5wvlKSyWlOvsR/ImXeHqPHEfwIbSTAwD0jb46
       "]]},
     Annotation[#, "Charting`Private`Tag$15885#1"]& ]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 3}, {-3.9999987777475323`, 35.99999706122455}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.7135590162076344`*^9, {3.7135592413558764`*^9, 
   3.7135592700870466`*^9}},ExpressionUUID->"9be2c91e-73a9-4653-9ef7-\
b3220143249a"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 9", "Section",
 CellChangeTimes->{{3.7132360358875327`*^9, 
  3.7132360371682196`*^9}},ExpressionUUID->"64ce845d-da60-4d4e-bfd3-\
41d25d97b1d1"],

Cell["State the Second Derivative Test.", "Text",
 CellChangeTimes->{{3.713236968060338*^9, 3.7132369811442337`*^9}, {
  3.713238103378575*^9, 
  3.7132381044433203`*^9}},ExpressionUUID->"95b56bc2-8c0d-47d9-8d6c-\
692117207b10"],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.7135500568301964`*^9, 
  3.713550057661414*^9}},ExpressionUUID->"440a3662-0c85-49d1-a860-\
7fa07b4fe907"],

Cell[TextData[{
 "Let ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "4d0b7a36-7906-4aff-a38f-f6c540aa4893"],
 " be a function such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"f", "'"}], 
     RowBox[{"(", "c", ")"}]}], "=", "0"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "2975ec15-aae7-40de-a99b-5ade5cb81989"],
 " and the second derivative of ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "6f6c2eaa-b53a-46bc-a036-fa124da2bcae"],
 " exists on an interval containing ",
 Cell[BoxData[
  FormBox["c", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "44184056-dd81-4e56-ac3e-f6df2436af41"],
 "."
}], "Text",
 CellChangeTimes->{{3.713236968060338*^9, 3.713236973860177*^9}, {
  3.7135699616944017`*^9, 
  3.7135700165980835`*^9}},ExpressionUUID->"837c07fa-6efd-4047-b91a-\
2343f80dd406"],

Cell[CellGroupData[{

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"f", "''"}], 
     RowBox[{"(", "c", ")"}]}], ">", "0"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "9826bd91-837b-478b-8c59-ee3452872afd"],
 ", then ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "689885a1-3e5b-43ad-8e64-127b3b8946ec"],
 " has a relative minimum at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"c", ",", 
     RowBox[{"f", "(", "c", ")"}]}], ")"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "097057b4-45bd-4f9e-842d-639a0afda8dd"],
 "."
}], "ItemNumbered",
 CellChangeTimes->{{3.713236968060338*^9, 3.713236973860177*^9}, {
  3.7135699616944017`*^9, 
  3.7135700759276133`*^9}},ExpressionUUID->"b40a6abc-36fe-4b96-beff-\
9d06318fed47"],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"f", "''"}], 
     RowBox[{"(", "c", ")"}]}], "<", "0"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "3b103654-c1b1-45cc-8f56-1682a3b75d46"],
 ", then ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "7313decd-51bf-4b86-9bab-f6c79680dacc"],
 " has a relative maximum at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"c", ",", 
     RowBox[{"f", "(", "c", ")"}]}], ")"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "be74a851-3454-40b1-9521-5ff04b7ed61b"],
 "."
}], "ItemNumbered",
 CellChangeTimes->{{3.713236968060338*^9, 3.713236973860177*^9}, {
  3.7135699616944017`*^9, 3.7135701023754063`*^9}, {3.7135701525370355`*^9, 
  3.7135701525375357`*^9}},ExpressionUUID->"461d1b40-af04-4b47-ab0a-\
e6f7d228bd2e"],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"f", "''"}], 
     RowBox[{"(", "c", ")"}]}], "=", "0"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "8b79a049-e068-4b08-829d-eddfa732a11d"],
 ", then the test fails."
}], "ItemNumbered",
 CellChangeTimes->{{3.713236968060338*^9, 3.713236973860177*^9}, {
   3.7135699616944017`*^9, 3.7135701023754063`*^9}, 
   3.7135701529487457`*^9},ExpressionUUID->"9f3eb5e3-9099-4ba6-a949-\
4bb9d8751975"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 10", "Section",
 CellChangeTimes->{{3.713236039199822*^9, 
  3.7132360418072557`*^9}},ExpressionUUID->"bdb4b9e4-e0e4-4ab5-bc41-\
4532cfdc2790"],

Cell[TextData[{
 "Find and classify all critical points of the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", 
     RowBox[{"(", "x", ")"}]}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3"}], 
      SuperscriptBox["x", "5"]}], "+", 
     RowBox[{"5", 
      SuperscriptBox["x", "3"]}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "5b621385-8552-4afb-9956-8f672ecde594"],
 "."
}], "Text",
 CellChangeTimes->{{3.7132369896523333`*^9, 
  3.7132370256061144`*^9}},ExpressionUUID->"f48cc877-c2e7-452b-a207-\
13fd886100f0"],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.7135500618055515`*^9, 
  3.713550062686347*^9}},ExpressionUUID->"de2c531a-b567-47ab-8525-\
e0d55217f1fb"],

Cell[TextData[{
 "First, we find the critical points (places where ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"f", "'"}], 
     RowBox[{"(", "x", ")"}]}], "=", "0"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "8b9ead48-ae02-4d8e-99ac-f009baac63c2"],
 "):\n",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"f", "'"}], 
     RowBox[{"(", "x", ")"}]}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "15"}], 
       SuperscriptBox["x", "4"]}], "+", 
      RowBox[{"15", 
       SuperscriptBox["x", "2"]}]}], "=", 
     RowBox[{
      RowBox[{"-", "15"}], 
      RowBox[{
       SuperscriptBox["x", "2"], "(", 
       RowBox[{
        SuperscriptBox["x", "2"], "-", "1"}], ")"}]}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "099cd6b0-8036-424e-a801-da29f2e2faca"],
 "\nSo we see that there are 3 critical points: x=-1,0,1. Now we take the \
second derivative and plug these points in there:\n",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"f", "''"}], 
     RowBox[{"(", "x", ")"}]}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "60"}], 
      SuperscriptBox["x", "3"]}], "+", 
     RowBox[{"30", "x", " "}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "bccb2229-c89e-491e-83b0-5a21e3ac5c0e"],
 "\n\n",
 Cell[BoxData[GridBox[{
    {Cell[TextData[Cell[BoxData[
      FormBox["x", TraditionalForm]],
      FormatType->"TraditionalForm",ExpressionUUID->
      "e75a9031-5e28-43aa-a1ff-df22cb9570fc"]],ExpressionUUID->
      "30e4cd55-79f9-4220-9ca3-cdfb9748bc9e"], Cell[TextData[Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{"f", "''"}], 
        RowBox[{"(", "x", ")"}]}], TraditionalForm]],
      FormatType->"TraditionalForm",ExpressionUUID->
      "b60b007e-8805-4d50-b115-32d397f1b558"]],ExpressionUUID->
      "666dcc56-4ddc-40c1-aff2-699da851dd3b"], 
     RowBox[{"test", " ", "result"}]},
    {
     RowBox[{"-", "1"}], "90", 
     RowBox[{"relative", " ", "minimum"}]},
    {"0", "0", "inconclusive"},
    {"1", 
     RowBox[{"-", "30"}], 
     RowBox[{"relative", " ", "maximum"}]}
   },
   GridBoxDividers->{
    "Columns" -> {False, {True}, False}, "ColumnsIndexed" -> {}, 
     "Rows" -> {False, {True}, False}, "RowsIndexed" -> {}}]],ExpressionUUID->
  "1dcc6c3a-7f42-40ff-b26e-9e5de1df8396"],
 "\n\nSince the test was inconclusive, to classify ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "0"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "bffab534-665d-4096-b51c-3bffd75bfcfe"],
 " we use the first derivative test. We will check the values of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "'"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "7c392940-24ed-41ec-8b0d-fb7cf6085804"],
 " on either side of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "0"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "44807d34-e8fb-4f71-b50f-3b2286620839"],
 " by checking at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", 
    RowBox[{
     RowBox[{"\[PlusMinus]", 
      FractionBox["1", "2"]}], ":"}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "76d17234-c902-4e36-9fb0-934d1cc91262"],
 "\n",
 Cell[BoxData[{
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"f", "'"}], 
     RowBox[{"(", 
      RowBox[{"-", 
       FractionBox["1", "2"]}], ")"}]}], "\[AlignmentMarker]", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "15"}], 
      RowBox[{"(", 
       FractionBox["1", "4"], ")"}], 
      RowBox[{"(", 
       RowBox[{
        FractionBox["1", "4"], "-", "1"}], ")"}]}], "=", 
     FractionBox["45", "16"]}]}], TraditionalForm], "\[IndentingNewLine]", 
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"f", "'"}], 
     RowBox[{"(", 
      FractionBox["1", "2"], ")"}]}], "\[AlignmentMarker]", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "15"}], 
      RowBox[{"(", 
       FractionBox["1", "4"], ")"}], 
      RowBox[{"(", 
       RowBox[{
        FractionBox["1", "4"], "-", "1"}], ")"}]}], "=", 
     FractionBox["45", "16"]}]}], TraditionalForm]}],
  FormatType->"TraditionalForm",
  FontSize->16,ExpressionUUID->"3195f3b4-dff5-4e26-85d4-4d6bd0c6eb57"],
 "\nSince the sign of the derivative does not change as we pass from one side \
of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "0"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "be83630f-7fdf-41fb-97a5-1a093e44fc42"],
 " to the other, this means that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"0", ",", "0"}], ")"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "e0570d3a-35d6-4c30-943a-a09bb2e32824"],
 " is an inflection point for this function. Observe the graph of the \
function below:"
}], "Text",
 CellChangeTimes->{{3.7132369896523333`*^9, 3.7132370221964226`*^9}, {
  3.7135701700395885`*^9, 3.713570354444008*^9}, {3.713570419911708*^9, 
  3.713570490794716*^9}, {3.7135705435770884`*^9, 3.713570601312192*^9}, {
  3.713570640625363*^9, 3.713570746036332*^9}, {3.713570796294748*^9, 
  3.7135709833760386`*^9}},ExpressionUUID->"e81e43f7-64ca-4140-8942-\
2ad46f577b20"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "3"}], 
     RowBox[{"x", "^", "5"}]}], "+", 
    RowBox[{"5", 
     RowBox[{"x", "^", "3"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1.3"}], ",", "1.3"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7135710560402217`*^9, 
  3.713571107754003*^9}},ExpressionUUID->"93695dad-377f-491e-836c-\
873f6e0a3672"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwtmnc0l+/7wFFJyUx9RKKIigopKbloymioNBBCVJQKqVRISLJnZJYRGZkJ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       "]]},
     Annotation[#, "Charting`Private`Tag$17615#1"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->{437., Automatic},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-1.3, 1.3}, {-1.9999982836976002`, 1.9999985568819012`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.713571080027548*^9, 
  3.7135711083230023`*^9}},ExpressionUUID->"c5845b3b-0bc9-4612-a1eb-\
92c71170ffc6"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 11", "Section",
 CellChangeTimes->{{3.713236043904008*^9, 3.713236045023195*^9}, {
  3.713570659216909*^9, 
  3.7135706614086113`*^9}},ExpressionUUID->"feb30fc7-7eb1-49f5-9026-\
f00ef675d0a8"],

Cell[TextData[{
 "A baseball player running from second base to third base at a speed of ",
 Cell[BoxData[
  FormBox["25", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "f503928c-1569-4b50-8df9-01b1f725cd59"],
 " feet per second is ",
 Cell[BoxData[
  FormBox["20", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "31c655f7-68f9-4da6-89ca-b444c6897a6e"],
 " feet away from third base. At what rate is the player\[CloseCurlyQuote]s \
distance ",
 Cell[BoxData[
  FormBox["s", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "c376f9b9-9a66-4138-b922-5332d9957e4f"],
 " from home plate changing?"
}], "Text",
 CellChangeTimes->{{3.7132370804592648`*^9, 3.713237151603834*^9}, {
   3.7132371849388576`*^9, 3.713237188708766*^9}, 3.713237221809761*^9, {
   3.713468989450657*^9, 
   3.713468996554131*^9}},ExpressionUUID->"664b5388-9817-4cb3-be39-\
505b6a391a10"],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.71355006688573*^9, 
  3.713550067742457*^9}},ExpressionUUID->"90218f1d-2563-46c2-bc07-\
b3d1f819fbd1"],

Cell[TextData[{
 "Bases are ",
 Cell[BoxData[
  FormBox[
   RowBox[{"90", "ft"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "8ad9fc84-6abb-4b64-99c8-ceed93663946"],
 " apart. Let ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "27ac7098-b4ec-46c2-8cd0-c824aa3c5d6f"],
 " stand for the distance the runner is away from third base, then we can \
construct the following right triangle (third base is at the corner with the \
right angle)"
}], "Text",
 CellChangeTimes->{{3.7132370804592648`*^9, 3.713237151603834*^9}, {
  3.7132371849388576`*^9, 3.713237188708766*^9}, {3.7135757531848106`*^9, 
  3.713575800224549*^9}, {3.713575861696184*^9, 3.7135759014677343`*^9}, {
  3.713576276719226*^9, 
  3.7135762858798475`*^9}},ExpressionUUID->"459ea6f2-5c37-4cc5-9856-\
e2fd53ee9966"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "90"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "10"}], ",", "90"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "10"}], ",", "20"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", 
      RowBox[{"(", 
       RowBox[{"3", "/", "10"}], ")"}]}], ",", 
     RowBox[{"Axes", "\[Rule]", "False"}]}], "]"}], ",", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "y"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", "20"}], "}"}]}], "]"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"20", "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "/", "9"}], ")"}], "x"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "90"}], "}"}]}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"Text", "[", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"\"\<x\>\"", ",", "Large"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "3"}], ",", "10"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"Text", "[", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"\"\<s\>\"", ",", "Large"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"45", ",", "14"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"Text", "[", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"\"\<90\>\"", ",", "Large"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"45", ",", 
        RowBox[{"-", "5"}]}], "}"}]}], "]"}], "]"}]}], "]"}]], "Input",
 CellOpen->False,
 CellChangeTimes->{{3.7135759171687517`*^9, 3.713575920624586*^9}, {
  3.7135761778922224`*^9, 3.713576249227283*^9}, {3.7135763332211304`*^9, 
  3.713576439786687*^9}, {3.713577888510828*^9, 3.71357788964344*^9}, {
  3.7135779212748537`*^9, 
  3.713578095431595*^9}},ExpressionUUID->"eca2aa3a-ccb0-4593-b04e-\
04a35518f519"],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJxNz30sFAAUAPArmdVR3ZrPk8axotA67rrI3blzOJxvu00+OoyTEJcdydVK
Vrgwtv5gUs7MLusSjmQ1VtauXMpaYu50R1NuSURsqi3vedvb229v7709Z1Fe
TMZOAoEQ8Tf/1QtvvA73agcDCP8jwNTqK+I2Mresa6bVu3KVYJVUNmTOHQA7
GCmJKxwNWEBeaTNxJsFZtGnNPOcbeHno3fQXzga41fi76JTEirXluEyiJ19v
DSa73JZVGhzBxxQSy3WmC7ilwDWqW+MG1hYx6dcV7mDn5HFBUo4nOGOzp/Ng
8XGw7Ve1ha3oBFhC9Z+s8/ABixY2Rg7M+4IfBBZaNI/Swa0/s58r6xngVbbd
62GZH3iKYLaoP3sanOuYV3OVwgR3ikeeNZSzwCVL9r+OitngZT4v4WVKIJiR
WMs2RnPAY/ZN2cNULtih7dpA+5EgsFrnES6w4oGd3n/PLFpAUxtqlfd1weCm
XUtedUMh4B6290R5Xyj4Dv0WaaODDx79pLhBrQoDd0c0uuZfCQcvno8l5KZH
4D889ywTRwBuX/i4WkiLBAtbFGlJllHgrkdhKWYVaAZ5bO3mGpqiy5x4K44G
G4jnIhs/o7VyQVpwfAy4XtpMvKhFDwxurqWFxoL3nWFVUPvRjFRTe7lPHFj+
pFSsbkMHFzrkK23iwR9q3YiUGnSdBSmoZEcC3vsxlSgxQ89NdRTkmqP9H3Pv
inajZ1Ol63wS2q9/WkV2RhtyOp2estB7hZd8ewPRDE5IuIqLltvPFCtC0Cdf
WI9XR6GrD12uTE5Fq/fw7wlF6Jllm76Y9G3zmoezvKxtfamB7Z2PtkxXCd0L
0PTIsjyKBF3lZtdkK0X37Dd2kUrQ+nXVK2Lptn1zZXrzMjRtLGx1U4b+A/Om
ETM=
        "]]},
      Annotation[#, "Charting`Private`Tag$27062#1"]& ]}, {}, {}}, {{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], FaceForm[Opacity[0.3]], LineBox[CompressedData["
1:eJx1x2tIUwEYxvGxmYFOm0VhlnPTLXVOM5XQliYpstQGiTOkJGetaeYVpZYH
Aj9sDjSdhuUtE9QulqCdIi8NUSGn7mRaWVIiathsVDJnZrouRO9Lg/7w8PDj
puUkyOk0Gu3or/3+/yXqPtlj9FAe+tcaG9fY+I6Nu2yst/EbMOGdTjsfsAiW
FEUKTflmsJRbU0i2fwNbdT1fpkNpkX9d3E5fvpnKACcpS0sYo/Zg+elevxxv
B3CLc/Ru1yNO4LrYzc8Cj7PARPb1/csmF/BaE8HvvbQNzImipyQKtoOnB4NF
jk92gKNJ+7TKPFew+IGQxWa7gecrrWeG7u8C+8zk0aNOuYPtnLUxb81s8OCL
20ZPKQcsvdtpThZywUG5W49xLOg5U/84RXmCZ5L1t5i1XuB7EmVfvIwHjl9T
bhSE8cGh1WNlQsYe8OqHC4dH36HVA0MHsklvcNqVHFUj4QN2YSlWHkt9wU7F
ZJeMIwBPFrX1MRfQhULzx0adHzjVUHGuXy0Ee/AvOxlk/mBB1gBD4R8Atgvv
CGdY0J0Dn+vUhr3gJPf+VkNcIDicJLVxXWjHLcSNYd4+8A/Zp0QXDTqFpXEf
taBnH1HlkhNBYAnX6DWuQ/MW/Ib1gmAwp2Wnm6YcXRrRYYnVor9Oip8zq9CU
w8WSimo0kftq5VoD+rWoaqK1DV0xziwbfIpez2xOV+nRik0Ho8Uj6IjQzO8j
FNrUoM+YeIkWZ6hiZufQJJ3t2fwe7VH/cEO+gF6h5knjIro5JMpraQnNoqas
nWZ0kSJ/qsCCTqht0q6uonXBYVnda2hfw5iYWEdfPZvOi7Ci/xQS+RMkZg7D

       "]]},
     Annotation[#, "Charting`Private`Tag$27100#1"]& ]}, {{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJwVyn8003scx/FJSqwrypIZMT+iwnxDy/J5s6G28mO06x63YuZKP5G6QtEP
KUwR3a6M3MxxHclIU+3WOiKJKHYVdjdd1PErhfIr7vf+8T7v8zivpzn/GDdi
CYFA2I3f/z/mlb2NtP2x++MJ65nFRQzcx0qc+awCNLE9Y/bIAgbqIpdcS1YF
srn0aa5nHgNJfHK9FkuGrprULUhnMDAeoIZ8ZbagMK+dS6MnMPAlfy0dY/ai
pb8d0lMPYnDARdUyxBxB7G1VVvJWDKbqO1QfmfPo7xQ6N+UmBiUDsye3xa2E
89XU3zPtMQiK1N3M7jMEnRG+y+smJyBbXEnO6DeBP8NaJWsinGCTOI44hyxA
lahH7p+mQXGspX9tixWMiUq7h6/RoP0kcr0gtoVcgeGlZGsamO9T+O49vBm4
kXdXGzxyhIjF+5WUU44wFFM41ctzhLXDdcvX8p3AwbM5PbLTAeIwRm+O3RZw
r9LoSl3hAPzR+abVQ86Qcv2KqtjTHu54Hl9e1OYKIw0t9YqDm6Fk8uDTilw6
ELXuBSUUb4JpD6PWZ8lu8JOQ/dTl+UZQEjQ/94Vthy6h69D4uB0cNTl29SwV
gXbhqydkWzuojGqS56UC/PJtTcw+f1tImFj3bWOUB8SHarXpX9wAU2xv3vP9
nlBrINZWltsAPSTbYyCACdTtNxfEHdbwZp3o4DOMBd6/uhWrdKzBuPS8rGyD
F+TOppvRaFZQp7bb5bvSG64LL7AnIizBtHM88uSoN7y40UmrKaQClpddcVvt
AxtGOybTGy1AtHTCPqd+BzACTgs65s3hvodDd+qDnZC4oLiLWZjDDdd0/fly
NgxTU6XZnPXQ1iO+iGVywLRa1iVfZga1uwsso1N2gbyy9ZswiAKfjwQSjgp2
Q2OzUwzjCRmmvG0PjDF9wbGLFT5IM4ay0XfTx1384MuJWqL8nBEEF4vD9xL9
wXRLgl7iOAlqqjn7NdP84dYF0YsIhiHQyW9mLs/4Q+bkGiVNvBqo6sju11EB
0B1Ej5oxNIB+3UN+Bf8GQIqPrGJcsAras3zDffZwYX2N9bWc4pWQG1+ke6Kd
Cx/nst1uO+uA7PHiTPjOQIi2+lFR/m4Z6P0MadjDQGgXPjM/IdUEeuhYWeqW
IFAbf+otDCBA1qOkqLrSIIhuPZ9H4swin+PG0RWkPSC3VgYqDSZRV7aVLvXq
HlDnhKkaSodQznJ9rwQNHshLA+ullF4k+6IMidPkQYrAbBju9KAPyvLYo1o8
IFgMGzQzehDjHusWfwW+i87xe0O60WBo/BxbH99zJRoa+W+R20OVhGzOAzir
B2ySAvUfrjT9C/Beev3UA0oL+iE40VnqifeY/YuXjJeIztyxS8LCXdlg9E9I
M8pa9/6UeAfel0xKl+Q3oa2NhgqhP77ncL9ySA1IaHY6Y18o7rcmgzKKDNXp
sP8I5uNu46T2hTxE76dID7gC3I0Jlsvy69DWlqpB7wO4q9/y/Ui16H18v4dD
NG5j2yf1lApEFEiCbWNxa6d9J+aXIVe/M8eocbgn+914JDHKtDISrY3HXeAR
85pSgO6vGqjRT8Cd9H00nJSH+uYkzbpJuMtiFSOUTET8cKZP6wzuqk4R1TQJ
ubzhTC8m4yYQtGmCm+7/AWjlJds=
        "]]},
      Annotation[#, "Charting`Private`Tag$27126#1"]& ]}, {}, {}}, InsetBox[
    StyleBox["\<\"x\"\>",
     StripOnInput->False,
     FontSize->Large], {-3, 10}], InsetBox[
    StyleBox["\<\"s\"\>",
     StripOnInput->False,
     FontSize->Large], {45, 14}], InsetBox[
    StyleBox["\<\"90\"\>",
     StripOnInput->False,
     FontSize->Large], {45, -5}]},
  AspectRatio->NCache[
    Rational[3, 10], 0.3],
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-10, 90}, {-10, 20}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.713576361763994*^9, 3.7135764403949637`*^9}, {
  3.713577959788912*^9, 3.713577988858758*^9}, {3.7135780198587*^9, 
  3.7135780301461105`*^9}, {3.713578060728208*^9, 
  3.7135780960829206`*^9}},ExpressionUUID->"b7fbeee1-4975-4c16-a5c0-\
a5b982999dd1"]
}, Open  ]],

Cell[TextData[{
 "Using this triangle and the Pythagorean theorem, we can find the \
relationship between ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "114d43b9-3505-42ad-9b74-33c6e3c8ca27"],
 " and ",
 Cell[BoxData[
  FormBox["s", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "16a410a5-1979-4fef-ad95-a61626d3ab4b"],
 " to be: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["s", "2"], "=", 
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["90", "2"]}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "766f9615-fd60-46bb-9c2e-159b5ddead22"],
 ". Now, both ",
 Cell[BoxData[
  FormBox["s", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "2f861932-62ad-4f5e-8c33-e479720b2d8e"],
 " and ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "469e53a9-065d-404d-ba61-468fc3f65f28"],
 " are changing with respect to time, so we take ",
 Cell[BoxData[
  FormBox[
   FractionBox["d", "dt"], TraditionalForm]],
  FormatType->"TraditionalForm",
  FontSize->18,ExpressionUUID->"fa1e16c2-c6ea-4a46-8262-d3e6bddc5fce"],
 " of both sides and get: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"2", "s", " ", 
     FractionBox["ds", "dt"]}], "=", 
    RowBox[{"2", "x", " ", 
     FractionBox["dx", "dt"]}]}], TraditionalForm]],
  FormatType->"TraditionalForm",
  FontSize->18,ExpressionUUID->"9427cccc-06f1-42a6-af72-00d3ebea7d3b"],
 ". Since we are looking for how the distance ",
 Cell[BoxData[
  FormBox["s", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "64e15a5a-5321-4f7e-8440-0e710b86ddca"],
 " is changing, we isolate ",
 Cell[BoxData[
  FormBox[
   FractionBox["ds", "dt"], TraditionalForm]],
  FormatType->"TraditionalForm",
  FontSize->18,ExpressionUUID->"b61896e5-01a4-4818-8448-8680d2f1e2e8"],
 " and get: ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{
     FractionBox["ds", "dt"], "=", 
     FractionBox[
      RowBox[{"x", " ", 
       FractionBox["dx", "dt"]}], "s"]}],
    FontSize->18], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "0ba6e171-d2fc-4812-a3a6-5050821e4118"],
 ". When ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "20"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "c25ddcb1-f480-47ca-859f-307e145d225e"],
 ", we know that ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{
     FractionBox["dx", "dt"], "=", "25"}],
    FontSize->18], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "cc8d0d2e-76cb-46c3-914a-d0b1f5241bc6"],
 ", and we can find the value of ",
 Cell[BoxData[
  FormBox["s", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "fead59ff-3df3-4c91-929f-c63340eb981b"],
 " using the equation we found from the triangle: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["s", "2"], "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", "20", ")"}], "2"], "+", 
      SuperscriptBox["90", "2"]}], "=", 
     RowBox[{
      RowBox[{"400", "+", "8100"}], " ", "=", " ", "8500"}]}]}], 
   TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "96d3f73e-2efd-4028-81c6-1940fe3a1ddf"],
 ", so ",
 Cell[BoxData[
  FormBox[
   RowBox[{"s", "=", 
    RowBox[{"10", 
     SqrtBox["85"]}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "863d21df-8ae5-4e23-8448-ec177e38ef26"],
 "and find ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox["ds", "dt"],
    FontSize->18], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "20fd4865-7dab-4fb5-9dc2-72244e966868"],
 " to be: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox[
     FractionBox["ds", "dt"],
     FontSize->18], 
    StyleBox["=",
     FontSize->18], 
    RowBox[{
     StyleBox[
      FractionBox[
       RowBox[{
        RowBox[{"(", "20", ")"}], 
        RowBox[{"(", "25", ")"}]}], 
       RowBox[{"10", 
        SqrtBox["85"]}]],
      FontSize->18], 
     StyleBox["=",
      FontSize->18], 
     FractionBox[
      StyleBox["50",
       FontSize->18], 
      SqrtBox["85"]]}]}], TraditionalForm]],ExpressionUUID->
  "7f5e2a58-8e7f-4688-bc3a-3791e2bf3a97"]
}], "Text",
 CellChangeTimes->{{3.713578136262658*^9, 3.7135783988955383`*^9}, {
  3.7135787529221935`*^9, 3.713578784313694*^9}, {3.713578896690511*^9, 
  3.7135789665553093`*^9}, {3.7135791230740557`*^9, 
  3.7135792231565557`*^9}},ExpressionUUID->"8e212560-f786-4e0a-863b-\
43b9495615f1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 12", "Section",
 CellChangeTimes->{{3.713236048327639*^9, 3.713236049599577*^9}, {
  3.713411960023633*^9, 3.713411961164072*^9}, {3.713412471710431*^9, 
  3.713412472334359*^9}},ExpressionUUID->"5c77de86-744f-4564-80aa-\
3101311579e5"],

Cell["\<\
Find the two positive numbers, where one is the reciprocal of the other, \
whose sum is as small as possible.\
\>", "Text",
 CellChangeTimes->{{3.71323719968515*^9, 
  3.7132372191520724`*^9}},ExpressionUUID->"fe6795ed-cd95-4433-88e4-\
73ba1dce8187"],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.7135500728304887`*^9, 
  3.713550073797679*^9}},ExpressionUUID->"bb50993f-ff01-4989-8a27-\
77282f40a142"],

Cell[TextData[{
 "If we call the first number ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "62621af9-c1d8-4018-83a8-b314050b8afb"],
 " then the second number is ",
 Cell[BoxData[
  FormBox[
   FractionBox["1", "x"], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "e5de6a9f-34c6-4d56-8391-fa47b21ef1ca"],
 " since they are reciprocals. We want to minimize the sum of these two \
numbers, meaning we want to minimize the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "x", ")"}], "=", 
    RowBox[{"x", "+", 
     FractionBox["1", "x"]}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "091c78ca-f068-4f35-89df-109a66bc75ac"],
 ". Start by finding the critical points:\n",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"f", "'"}], 
     RowBox[{"(", "x", ")"}]}], "=", 
    RowBox[{
     RowBox[{"1", "-", 
      FractionBox["1", 
       SuperscriptBox["x", "2"]]}], "=", 
     FractionBox[
      RowBox[{
       SuperscriptBox["x", "2"], "-", "1"}], 
      SuperscriptBox["x", "2"]]}]}], TraditionalForm]],
  FormatType->"TraditionalForm",
  FontSize->18,ExpressionUUID->"d6883732-439a-4de7-bf39-c5d73af42b46"],
 "\nwhich has zeros at ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"x", "=", 
     RowBox[{"-", "1"}]}], ",", "1"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "c384ebec-2436-4b9c-839b-54190dfb025b"],
 ". Now, we only want positive numbers, so we ignore ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", 
    RowBox[{"-", "1"}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "aa07b687-a4f4-4cbc-9ef7-3f8b53af653e"],
 " and just check if ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "1"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "23e4ae14-345b-4b26-a127-60bdde4fb6b9"],
 " is a minimum. We\[CloseCurlyQuote]ll use the first derivative test to \
check whether it\[CloseCurlyQuote]s a max or min by checking the sign of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "'"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "40972155-eba0-401b-a5ed-e84b84ce5f17"],
 " at ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"x", "=", 
     FractionBox["1", "2"]}], ",", 
    FractionBox["3", "2"]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "a02fc840-77a6-44cc-a310-df2c5bf385b6"],
 ":\n",
 Cell[BoxData[{
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"f", "'"}], 
     RowBox[{"(", 
      FractionBox["1", "2"], ")"}]}], "=", 
    RowBox[{
     RowBox[{"1", "-", 
      FractionBox["1", 
       RowBox[{"1", "/", "4"}]]}], "=", 
     RowBox[{"-", "3"}]}]}], TraditionalForm], "\[IndentingNewLine]", 
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"f", "'"}], 
     RowBox[{"(", 
      FractionBox["3", "2"], ")"}]}], "=", 
    RowBox[{
     RowBox[{"1", "-", 
      FractionBox["1", 
       RowBox[{"9", "/", "4"}]]}], "=", 
     FractionBox["5", "9"]}]}], TraditionalForm]}],
  FormatType->"TraditionalForm",
  FontSize->18,ExpressionUUID->"6fff47b0-0969-4119-8e0d-d0892d78eb0c"],
 "\nSince the sign of the derivative goes from negative to positive as we \
pass over the critical point, this means that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "1"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "09e76ad6-7ec3-4ab5-89f5-1fc3d1a83392"],
 " is a ",
 StyleBox["minimum",
  FontWeight->"Bold"],
 ". This means that the two numbers we are looking for which are reciprocals \
and have the smallest sum are 1 and 1."
}], "Text",
 CellChangeTimes->{{3.71323719968515*^9, 3.713237215950399*^9}, {
  3.713571729657128*^9, 3.713571817642277*^9}, {3.7135725824911594`*^9, 
  3.7135726300199313`*^9}, {3.7135727230040483`*^9, 3.7135727993551865`*^9}, {
  3.713572896957296*^9, 3.7135729666547527`*^9}, {3.71357306067704*^9, 
  3.7135730909190536`*^9}, {3.713573312118194*^9, 3.713573326565675*^9}, {
  3.7135733860292416`*^9, 
  3.713573513807045*^9}},ExpressionUUID->"7ab42d85-0f94-4ff2-9ebc-\
8610812beda6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 13", "Section",
 CellChangeTimes->{{3.713236052215852*^9, 
  3.7132360535595865`*^9}},ExpressionUUID->"cea77c38-5642-4008-aefa-\
a9d94db7d931"],

Cell[TextData[{
 "Find parametric equations for the ellipse ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{
     RowBox[{
      FractionBox[
       SuperscriptBox["x", "2"], "4"], "+", 
      FractionBox[
       SuperscriptBox["y", "2"], "9"]}], "=", "1"}],
    FontSize->18], TraditionalForm]],ExpressionUUID->
  "d87aa4d4-8e5c-4483-af09-8be693eae914"],
 ". (Hint: one choice of parametric equations for the circle ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"]}], "=", "1"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "5f54039b-fe8f-4f13-98e5-f922b406c15c"],
 " are ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"x", "=", 
     RowBox[{"cos", "(", "t", ")"}]}], ",", 
    RowBox[{"y", "=", 
     RowBox[{"sin", "(", "t", ")"}]}], ",", 
    RowBox[{"0", "\[LessEqual]", "t", "\[LessEqual]", 
     RowBox[{"2", "\[Pi]"}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "5e0598ec-a500-4c52-a2c5-80930a89657e"],
 ". Try to alter these to fit the ellipse.)"
}], "Text",
 CellChangeTimes->{{3.7132372262943707`*^9, 3.7132372707239003`*^9}, {
  3.7134673608143682`*^9, 
  3.7134674498800697`*^9}},ExpressionUUID->"b5d720be-bb99-4a9a-8f47-\
a3d97c01d2d4"],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.713550078350272*^9, 
  3.713550079149922*^9}},ExpressionUUID->"4519b3b8-ed60-4b35-b8f1-\
b88ab7ac0ec0"],

Cell[TextData[{
 "Since an ellipse is just a stretched out unit circle, we just need to \
stretch out the parametric equations of the circle. This ellipse is stretched \
by a factor of ",
 Cell[BoxData[
  FormBox["2", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "fab86b03-7b9f-450f-9add-1d5914ff9971"],
 " in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "4f47fcea-e028-41cd-971c-6671dcbf1bd4"],
 "-direction and by a factor of ",
 Cell[BoxData[
  FormBox["3", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "d1d8b6cf-73e2-4f0b-aaf6-7ab278283dea"],
 " in the ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "667e93a0-0c72-4d60-afda-484f9f8d5e3e"],
 "-direction, so a choice of parametric equations are"
}], "Text",
 CellChangeTimes->{{3.7132372262943707`*^9, 3.713237264314019*^9}, {
  3.7135504931747465`*^9, 3.7135506194784994`*^9}, {3.713550666343981*^9, 
  3.7135506754711103`*^9}},ExpressionUUID->"71c2505e-ef99-4b3f-9c1f-\
a4bfcd9da2ea"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"x", "=", 
    RowBox[{"2", 
     RowBox[{"cos", "(", "t", ")"}]}]}], ",", " ", 
   RowBox[{"y", "=", 
    RowBox[{"2", 
     RowBox[{"sin", "(", "t", ")"}]}]}], ",", " ", 
   RowBox[{"0", "\[LessEqual]", " ", "t", " ", "\[LessEqual]", " ", 
    RowBox[{"2", "\[Pi]"}]}]}], TraditionalForm]],
 FormatType->
  "TraditionalForm",ExpressionUUID->"ddb2c4f0-b7a3-4ab2-bf69-d60b621faaf7"]], \
"Text",
 CellChangeTimes->{{3.7132372262943707`*^9, 3.713237264314019*^9}, {
  3.7135504931747465`*^9, 3.7135506194784994`*^9}, {3.713550666343981*^9, 
  3.713550719193761*^9}},
 TextAlignment->Center,ExpressionUUID->"8b79d65e-3616-4966-b30f-0f37edf27c9c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 14", "Section",
 CellChangeTimes->{{3.7132360561354604`*^9, 
  3.713236060616027*^9}},ExpressionUUID->"889b0989-129a-4bd6-9d8f-\
846d1519f695"],

Cell[TextData[{
 "Compute the derivative of ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{
     RowBox[{"f", 
      RowBox[{"(", "x", ")"}]}], "=", 
     RowBox[{"ln", 
      FormBox[
       RadicalBox[
        StyleBox[
         FractionBox[
          RowBox[{"x", "-", "1"}], 
          RowBox[{"x", "+", "1"}]],
         FontSize->24], "3"],
       TraditionalForm]}]}],
    FontSize->16], TraditionalForm]],ExpressionUUID->
  "229baa4e-1a73-418a-92f1-6828350e88e6"],
 "."
}], "Text",
 CellChangeTimes->{{3.713237274690446*^9, 3.7132372994303646`*^9}, {
   3.713237701097741*^9, 3.7132377490336256`*^9}, 
   3.713237982922347*^9},ExpressionUUID->"2f801785-026c-4998-9222-\
e54092bbcc95"],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.713550082838217*^9, 
  3.7135500836138315`*^9}},ExpressionUUID->"c02d4d09-eb90-4c0f-9e84-\
40f08e87a8e3"],

Cell[TextData[{
 "This is just a repeated application of the chain rule:\n",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{
     RowBox[{"f", "'"}], 
     RowBox[{"(", "x", ")"}], 
     "\[AlignmentMarker]\[AlignmentMarker]\[AlignmentMarker]", "=", 
     RowBox[{
      RowBox[{
       FractionBox["d", "dx"], "[", 
       RowBox[{"ln", "(", 
        FormBox[
         RadicalBox[
          FractionBox[
           RowBox[{"x", "-", "1"}], 
           RowBox[{"x", "+", "1"}]], "3"],
         TraditionalForm], ")"}], "]"}], "=", 
      RowBox[{
       RowBox[{
        FractionBox["1", 
         RadicalBox[
          FractionBox[
           RowBox[{"x", "-", "1"}], 
           RowBox[{"x", "+", "1"}]], "3"]], 
        RowBox[{
         FractionBox["d", "dx"], "[", 
         RadicalBox[
          FractionBox[
           RowBox[{"x", "-", "1"}], 
           RowBox[{"x", "+", "1"}]], "3"], "]"}]}], "=", 
       RowBox[{
        RowBox[{
         FractionBox["1", 
          RadicalBox[
           FractionBox[
            RowBox[{"x", "-", "1"}], 
            RowBox[{"x", "+", "1"}]], "3"]], 
         FractionBox[
          FractionBox["1", "3"], 
          SuperscriptBox[
           RowBox[{"(", 
            RadicalBox[
             FractionBox[
              RowBox[{"x", "-", "1"}], 
              RowBox[{"x", "+", "1"}]], "3"], ")"}], "2"]], 
         RowBox[{
          FractionBox["d", "dx"], "[", 
          FractionBox[
           RowBox[{"x", "-", "1"}], 
           RowBox[{"x", "+", "1"}]], "]"}]}], "\[IndentingNewLine]", "=", " ", 
        RowBox[{
         RowBox[{
          FractionBox["1", 
           RadicalBox[
            FractionBox[
             RowBox[{"x", "-", "1"}], 
             RowBox[{"x", "+", "1"}]], "3"]], 
          FractionBox[
           FractionBox["1", "3"], 
           SuperscriptBox[
            RowBox[{"(", 
             RadicalBox[
              FractionBox[
               RowBox[{"x", "-", "1"}], 
               RowBox[{"x", "+", "1"}]], "3"], ")"}], "2"]], 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{"x", "+", "1"}], ")"}], "-", 
            RowBox[{"(", 
             RowBox[{"x", "-", "1"}], ")"}]}], 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"x", "+", "1"}], ")"}], "2"]]}], "=", 
         RowBox[{
          RowBox[{
           FractionBox["1", "3"], 
           FractionBox[
            RowBox[{"x", "+", "1"}], 
            RowBox[{"x", "-", "1"}]], 
           FractionBox["2", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"x", "+", "1"}], ")"}], "2"]]}], "=", 
          FractionBox["2", 
           RowBox[{"3", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["x", "2"], "-", "1"}], ")"}]}]]}]}]}]}]}]}],
    FontSize->18], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "fd47708f-2294-4c53-b7d8-6028054b49c8"]
}], "Text",
 CellChangeTimes->{{3.7132376407438707`*^9, 3.7132376475341754`*^9}, {
  3.713574097030756*^9, 3.7135744198639975`*^9}, {3.7135746625837*^9, 
  3.7135747146925354`*^9}, {3.713575162867787*^9, 
  3.7135751776075397`*^9}},ExpressionUUID->"0b850305-577a-4ef4-a8bd-\
f58f767b9f8c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 15", "Section",
 CellChangeTimes->{{3.713460900430779*^9, 
  3.71346091016926*^9}},ExpressionUUID->"85a6d833-fa69-48d7-a5ef-\
d95a0a61ef7f"],

Cell[TextData[{
 "Use Mathematica\[CloseCurlyQuote]s ",
 StyleBox["Plot", "Input"],
 " function to graph the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", 
     RowBox[{"(", "x", ")"}]}], "=", 
    RowBox[{"sin", "(", 
     FractionBox["1", "x"], ")"}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "a0020221-f42a-409d-9a96-f3369a07792e"],
 " on the interval ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", "1"}], "\[LessEqual]", "x", "\[LessEqual]", "3"}], 
   TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "d6c0fbd2-2c38-4cc9-a5bf-d9f211d7f52f"],
 ". (As you start typing the name of a command in Mathematica, you will see a \
list below your text with the commands. You can click on this to autocomplete \
the command name. If you click the i with a circle around it next to the \
command name (or on the box below the command if you did the autocomplete), \
an information window will pop-up with directions on how to use the command. \
Another tip: when entering functions like trig functions, you have to enter \
it with a capital letter and put square brackets around the input, for \
example, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Tan", "[", 
    SuperscriptBox["x", "2"], "]"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "28cb1643-53eb-42a0-a2c8-ab15d07f9281"],
 ".)"
}], "Text",
 CellChangeTimes->{{3.7134609367511854`*^9, 3.713460965174653*^9}, 
   3.713461083344061*^9, {3.7134640244708567`*^9, 3.713464041294555*^9}, {
   3.7134652060358257`*^9, 3.71346522235633*^9}, {3.7134652562532325`*^9, 
   3.713465261357519*^9}, {3.71346530338284*^9, 3.7134655000476236`*^9}, {
   3.713465885713647*^9, 3.713465981987656*^9}, {3.7134690442494645`*^9, 
   3.7134690476884613`*^9}},ExpressionUUID->"45e5ac41-63bc-4408-9eb9-\
b1f999d07e46"],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.713550093350638*^9, 
  3.713550094326132*^9}},ExpressionUUID->"69f9950d-6ef1-416a-ad15-\
a8e9d4283abc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"1", "/", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7135500861217475`*^9, 3.7135500877260437`*^9}, {
  3.7135504455595245`*^9, 
  3.7135504605517116`*^9}},ExpressionUUID->"3e5ad3dc-c286-4298-b1de-\
0b5160f4b898"],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJwVV3c81e8f1aCSJKNQKCWJNJSvhh4JLUKFEpFCqaxoIUSDolQyQ1KZkU1x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        "]], LineBox[CompressedData["
1:eJwVV3k4VP8bJaRCKsmS9oUWCREqZ6LSNypLQiJKm6SkFCG0kBYiypLse7Ik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        "]]},
      Annotation[#, 
       "Charting`Private`Tag$6334#1"]& ], {}}, {{}, {}, {}}}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->{618., Automatic},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-1, 3}, {-0.999999976437972, 0.9999992617052459}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.7135504627884574`*^9},ExpressionUUID->"1c5ac548-a0c6-49ff-9446-\
e15a67771286"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 16", "Section",
 CellChangeTimes->{{3.7134659913313117`*^9, 
  3.7134659987144785`*^9}},ExpressionUUID->"e7dfb4cd-118f-4b28-b71e-\
67fafcf4ea48"],

Cell[TextData[{
 "We will frequently work with 3D objects in this class. Typically, we can \
take a command that produces a 2D graph (e.g., ",
 StyleBox["Plot", "Code"],
 " or ",
 StyleBox["ParametricPlot", "Code"],
 ") and add ",
 StyleBox["3D", "Code"],
 " at the end of it. Use the ",
 StyleBox["ParametricPlot3D", "Code"],
 " command to plot the following vector valued function (parametric \
equations):\n",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"x", "=", 
     RowBox[{"t", " ", 
      RowBox[{"cos", "(", "t", ")"}]}]}], ",", 
    RowBox[{"y", "=", 
     RowBox[{"t", " ", 
      RowBox[{"sin", "(", "t", ")"}]}]}], ",", 
    RowBox[{"z", "=", 
     SuperscriptBox["t", "2"]}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "799e5775-3fdf-4356-957a-85e6145f53c7"],
 " for the t-values -4\[Pi] \[LessEqual] t \[LessEqual] 4\[Pi]."
}], "Text",
 CellChangeTimes->{{3.71346606025209*^9, 3.7134661679168577`*^9}, {
  3.713466262813053*^9, 
  3.7134664588111506`*^9}},ExpressionUUID->"fdb4209a-0ac0-459c-be69-\
5ec58c49906e"],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.7135500976650915`*^9, 
  3.7135501016615305`*^9}},ExpressionUUID->"3877f47c-b76d-4282-9da6-\
e2e639b7d746"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", " ", 
      RowBox[{"Cos", "[", "t", "]"}]}], ",", 
     RowBox[{"t", " ", 
      RowBox[{"Sin", "[", "t", "]"}]}], ",", 
     RowBox[{"t", "^", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{
      RowBox[{"-", "4"}], "\[Pi]"}], ",", 
     RowBox[{"4", "\[Pi]"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.713550405439849*^9, 
  3.713550427001627*^9}},ExpressionUUID->"c38f2b05-bd65-4a0a-a2e3-\
72168d016260"],

Cell[BoxData[
 Graphics3DBox[{{}, {}, 
   TagBox[
    {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[2], 
     Line3DBox[CompressedData["
1:eJwUl3c41u8Xx+3sjGyyd0hlFveRncyMbFkJJZXoi4jKaigKFRmRBpmF6PMh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      "]]},
    Annotation[#, "Charting`Private`Tag$6015#1"]& ]},
  Axes->True,
  DisplayFunction->Identity,
  FaceGridsStyle->Automatic,
  Method->{},
  PlotRange->{{-12.566370101444432`, 
   12.566370101444432`}, {-11.040707915408166`, 7.916726583864787}, {0., 
   157.9136575265181}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{Automatic, Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.713550427439807*^9},ExpressionUUID->"66fcf747-9574-4139-9d14-\
7d45fe254f3c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ParametricPlot3D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"t", " ", 
       RowBox[{"Cos", "[", "t", "]"}]}], ",", 
      RowBox[{"t", " ", 
       RowBox[{"Sin", "[", "t", "]"}]}], ",", 
      RowBox[{"t", "^", "2"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", 
      RowBox[{
       RowBox[{"-", "4"}], "\[Pi]"}], ",", 
      RowBox[{"4", "\[Pi]"}]}], "}"}], ",", 
    RowBox[{"BoxRatios", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1"}], "}"}]}]}], "]"}], " ", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "BoxRatios", " ", "and", " ", "the", " ", "numbers", " ", "after", " ", 
     "it", " ", "changes", " ", "the", " ", "lengths", " ", "of", " ", "the", 
     " ", "axes", " ", "in", " ", "the", " ", 
     RowBox[{"plot", ".", " ", "For"}], " ", "example"}], ",", " ", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1"}], "}"}], " ", "as", " ", "entered", 
     " ", "above", " ", "makes", " ", "it", " ", "so", " ", "all", " ", "of", 
     " ", "the", " ", "axes", " ", "have", " ", "the", " ", "same", " ", 
     RowBox[{"length", ".", " ", "This"}], " ", "can", " ", "sometimes", " ", 
     "help", " ", "us", " ", "visualize", " ", "the", " ", "graph", " ", "a", 
     " ", "bit", " ", 
     RowBox[{"better", ".", " ", "With"}], " ", "this", " ", "view"}], ",", 
    " ", 
    RowBox[{
    "we", " ", "can", " ", "better", " ", "see", " ", "the", " ", "fact", " ",
      "that", " ", "it", " ", "sits", " ", "on", " ", "a", " ", 
     RowBox[{"cone", "."}]}]}], "*)"}]}]], "Input",
 CellChangeTimes->{{3.7135501214206266`*^9, 3.713550167313215*^9}, {
   3.7135501982957783`*^9, 3.7135503293909883`*^9}, {3.71355039501565*^9, 
   3.7135503995303097`*^9}, 
   3.7135653987419357`*^9},ExpressionUUID->"7ae90c6f-57d7-4ba2-b332-\
4c635ce10fe8"],

Cell[BoxData[
 Graphics3DBox[{{}, {}, 
   TagBox[
    {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[2], 
     Line3DBox[CompressedData["
1:eJwUl3c41u8Xx+3sjGyyd0hlFveRncyMbFkJJZXoi4jKaigKFRmRBpmF6PMh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      "]]},
    Annotation[#, "Charting`Private`Tag$16640#1"]& ]},
  Axes->True,
  BoxRatios->{1, 1, 1},
  DisplayFunction->Identity,
  FaceGridsStyle->Automatic,
  ImageSize->{430.4726190536203, 438.0980087068847},
  ImageSizeRaw->Automatic,
  Method->{},
  PlotRange->{{-12.566370101444432`, 
   12.566370101444432`}, {-11.040707915408166`, 7.916726583864787}, {0., 
   157.9136575265181}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{Automatic, Automatic, Automatic},
  ViewPoint->{1.4959570914208469`, 2.685067568447208, 1.4151058382681767`},
  ViewVertical->{0.06743483579184403, 0.1912077589378039, 
   0.9792303793509012}]], "Output",
 CellChangeTimes->{
  3.713565400716613*^9},ExpressionUUID->"f6eb5608-0186-447a-b69f-\
7e24abdf9849"]
}, Open  ]],

Cell[TextData[{
 "I actually intended to make the ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "575b2771-401b-4e6a-8006-4fd20d2222db"],
 "-coordinate just ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "be71c586-8df0-4dd4-a175-2f9864653242"],
 ", not ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["t", "2"], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "d9e492a4-34c1-4a58-b5b0-19fb9b47220e"],
 ". The graph of that curve looks like this:"
}], "Text",
 CellChangeTimes->{{3.7136237267201757`*^9, 
  3.71362376957698*^9}},ExpressionUUID->"0d3f84a4-585a-4444-a841-\
de4ad4ae295e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", " ", 
      RowBox[{"Cos", "[", "t", "]"}]}], ",", 
     RowBox[{"t", " ", 
      RowBox[{"Sin", "[", "t", "]"}]}], ",", "t"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{
      RowBox[{"-", "4"}], "\[Pi]"}], ",", 
     RowBox[{"4", "\[Pi]"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7136237837946076`*^9, 
  3.713623783905423*^9}},ExpressionUUID->"b29ac2a1-ddf5-4a35-8a16-\
46e98e852cec"],

Cell[BoxData[
 Graphics3DBox[{{}, {}, 
   TagBox[
    {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[2], 
     Line3DBox[CompressedData["
1:eJwkV3c81d//t+Pa1957K1Iin3LeJSuhRCQhISFSpE2IpEFkk5XQMisq50XK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      "]]},
    Annotation[#, "Charting`Private`Tag$28038#1"]& ]},
  Axes->True,
  DisplayFunction->Identity,
  FaceGridsStyle->Automatic,
  ImageSize->{396.84026976306177`, 392.258515498982},
  ImageSizeRaw->Automatic,
  Method->{},
  PlotRange->{{-12.566370101444432`, 
   12.566370101444432`}, {-11.040707915408166`, 
   7.916726583864787}, {-12.566370101446086`, 12.566370101446086`}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{Automatic, Automatic, Automatic},
  ViewPoint->{1.6597268066304052`, -2.743606205649111, 1.080708987505946},
  ViewVertical->{0.09447041777537751, -0.39455779839341765`, 
   0.9500013011319908}]], "Output",
 CellChangeTimes->{
  3.71362378453959*^9},ExpressionUUID->"730031b2-97f4-4739-80ed-abbba817fa4d"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1280, 941},
WindowMargins->{{-8, Automatic}, {Automatic, 0}},
PrintingPageRange->{Automatic, Automatic},
FrontEndVersion->"11.1 for Microsoft Windows (64-bit) (April 18, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 231, 4, 101, "Title", "ExpressionUUID" -> \
"3eff84e4-7dc3-473c-9d5f-5004e7960755"],
Cell[CellGroupData[{
Cell[836, 30, 362, 7, 115, "Chapter", "ExpressionUUID" -> \
"c892a7ab-be06-4eb0-8538-11c3495d3863"],
Cell[1201, 39, 383, 7, 30, "Text", "ExpressionUUID" -> \
"76986328-9708-4592-8069-c192c864c775"],
Cell[CellGroupData[{
Cell[1609, 50, 397, 10, 19, "Code", "ExpressionUUID" -> \
"3191ef1e-9de0-4ec2-9679-4ed8e3e8381a",
 CellOpen->False],
Cell[2009, 62, 782, 21, 30, "Output", "ExpressionUUID" -> \
"d889dbb2-edf6-456f-94fb-bf03ad948e37"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2828, 88, 207, 4, 70, "Section", "ExpressionUUID" -> \
"4a24de52-2102-4d1e-9650-526a5cece368"],
Cell[3038, 94, 648, 19, 35, "Text", "ExpressionUUID" -> \
"96f24a6d-bfed-4a41-8f0d-b370d8e10799"],
Cell[CellGroupData[{
Cell[3711, 117, 158, 3, 49, "Subsection", "ExpressionUUID" -> \
"239273d6-da02-4260-b758-87b6f0338a92"],
Cell[3872, 122, 377, 5, 30, "Text", "ExpressionUUID" -> \
"1f3de8a8-1523-4789-a223-2fdcd97a950c"],
Cell[4252, 129, 2433, 68, 127, "Text", "ExpressionUUID" -> \
"73d05611-7b99-4c37-9f81-e1ceb6241b8e"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6734, 203, 158, 3, 70, "Section", "ExpressionUUID" -> \
"38cc62da-8763-4d8f-ac77-780f62bc6421"],
Cell[6895, 208, 1277, 36, 47, "Text", "ExpressionUUID" -> \
"b251f761-dae6-40ae-93e6-30fa8ae2e9d9"],
Cell[CellGroupData[{
Cell[8197, 248, 160, 3, 49, "Subsection", "ExpressionUUID" -> \
"bf022f1e-391d-4bed-b8a3-8157d46db6f1"],
Cell[8360, 253, 388, 6, 30, "Text", "ExpressionUUID" -> \
"ddea3346-5bb2-49b5-a6eb-997972bc2360"],
Cell[8751, 261, 897, 23, 48, "Text", "ExpressionUUID" -> \
"45dac899-fedf-46c4-aa5b-0a57b4d722bb"],
Cell[9651, 286, 423, 6, 30, "Text", "ExpressionUUID" -> \
"087bf44b-bd83-4248-a4f3-1f4b28107ed7"],
Cell[10077, 294, 1005, 27, 47, "Text", "ExpressionUUID" -> \
"894f7d8f-a466-4891-8ae7-5e4e1afb008e"],
Cell[11085, 323, 672, 16, 47, "Text", "ExpressionUUID" -> \
"b9938733-edf7-4670-857f-60354c62d63c"],
Cell[11760, 341, 1004, 24, 47, "Text", "ExpressionUUID" -> \
"21d10baf-ecea-4c91-a82d-54a463d14b0c"],
Cell[12767, 367, 693, 17, 47, "Text", "ExpressionUUID" -> \
"03aad1fe-d584-49a5-b6bd-fb57368eceed"],
Cell[13463, 386, 1058, 26, 62, "Text", "ExpressionUUID" -> \
"5c0340f1-b834-4cd1-b857-b93f636255e7"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14570, 418, 156, 3, 70, "Section", "ExpressionUUID" -> \
"b558e9de-89e6-468c-a384-951f2a0bdef8"],
Cell[14729, 423, 932, 27, 36, "Text", "ExpressionUUID" -> \
"a6e3293d-cf1d-4b62-9efc-a0a5552f38fe",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[15686, 454, 160, 3, 49, "Subsection", "ExpressionUUID" -> \
"2e52da40-24e2-4eaa-84bb-d6a312e6c6b5"],
Cell[15849, 459, 456, 9, 30, "Text", "ExpressionUUID" -> \
"1fa24d72-4a7e-48e0-833c-39f3c9e93c20",
 InitializationCell->True],
Cell[16308, 470, 1459, 44, 54, "Text", "ExpressionUUID" -> \
"9247a95d-b4c5-418a-8551-3741aa3d9bbd",
 InitializationCell->True],
Cell[17770, 516, 452, 9, 30, "Text", "ExpressionUUID" -> \
"1f692ec0-0ac0-46dc-8e32-3c38040764c7",
 InitializationCell->True],
Cell[18225, 527, 683, 16, 47, "Text", "ExpressionUUID" -> \
"10346f7c-86ee-4915-acd7-c9c5cca46717",
 InitializationCell->True],
Cell[18911, 545, 347, 6, 30, "Text", "ExpressionUUID" -> \
"8cffccb6-1bf1-4b5f-8be0-34f9ac463558",
 InitializationCell->True],
Cell[19261, 553, 637, 14, 47, "Text", "ExpressionUUID" -> \
"13b764d1-fabc-4800-b922-a7a6558f6c5b",
 InitializationCell->True]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19947, 573, 156, 3, 70, "Section", "ExpressionUUID" -> \
"d9f59dcc-177e-49cd-b037-24d5bddbc1a0"],
Cell[20106, 578, 875, 23, 52, "Text", "ExpressionUUID" -> \
"8606eac9-7150-49df-a653-2bf09a893c5d"],
Cell[CellGroupData[{
Cell[21006, 605, 160, 3, 49, "Subsection", "ExpressionUUID" -> \
"a0024bbf-6968-495d-8848-aabf4d6670f4"],
Cell[21169, 610, 1419, 45, 42, "Text", "ExpressionUUID" -> \
"b918045e-d2ad-4329-94b4-87dc5cfdcb38"],
Cell[22591, 657, 1121, 34, 49, "Text", "ExpressionUUID" -> \
"bfed83b4-0f3f-4eaa-a12d-b4d2b5e8b292"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23761, 697, 181, 3, 70, "Section", "ExpressionUUID" -> \
"8a849707-7d64-4ab6-84bd-d2ca7003e56a"],
Cell[23945, 702, 489, 16, 35, "Text", "ExpressionUUID" -> \
"bb663dc5-2dea-42b5-a721-caf63f5372bf"],
Cell[CellGroupData[{
Cell[24459, 722, 155, 3, 49, "Subsection", "ExpressionUUID" -> \
"1cf78d96-98ff-49c5-8ddf-ae82b8745566"],
Cell[24617, 727, 812, 25, 32, "Text", "ExpressionUUID" -> \
"59934208-d55a-4da0-ae82-596e000d13bd"],
Cell[25432, 754, 923, 27, 40, "Text", "ExpressionUUID" -> \
"5b86ced5-3a2d-4740-afb8-ebaad4ceee1c"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[26404, 787, 153, 3, 70, "Section", "ExpressionUUID" -> \
"9b176684-111d-4f29-bacc-264336849fa2"],
Cell[26560, 792, 1125, 35, 32, "Text", "ExpressionUUID" -> \
"39594a9e-f325-4236-abf3-e2f0761de3dd"],
Cell[CellGroupData[{
Cell[27710, 831, 156, 3, 49, "Subsection", "ExpressionUUID" -> \
"8e9dfb86-620e-4ff0-b2d9-053a9d27e359"],
Cell[27869, 836, 1637, 48, 51, "Text", "ExpressionUUID" -> \
"6101bce0-37e5-49cc-ae58-dc5c113256f4"],
Cell[29509, 886, 1334, 38, 124, "Text", "ExpressionUUID" -> \
"212b731e-ad61-44b0-b7d3-14582063c682"],
Cell[30846, 926, 1207, 27, 63, "Text", "ExpressionUUID" -> \
"a1de7615-f39f-4d1d-b1a6-dbe2ba20b447"],
Cell[CellGroupData[{
Cell[32078, 957, 5549, 167, 295, "Input", "ExpressionUUID" -> \
"f6bdad0b-a1d6-456b-a04a-c7868deaae4c"],
Cell[37630, 1126, 22464, 396, 372, "Output", "ExpressionUUID" -> \
"02eca5f1-4325-489e-ba09-9c281172b488"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[60155, 1529, 156, 3, 70, "Section", "ExpressionUUID" -> \
"213b8a14-dd5d-4c8b-839d-d0746db10921"],
Cell[60314, 1534, 606, 17, 52, "Text", "ExpressionUUID" -> \
"140bdf55-ab75-4f74-9e26-7f21c5377a32"],
Cell[CellGroupData[{
Cell[60945, 1555, 181, 3, 49, "Subsection", "ExpressionUUID" -> \
"499dc021-5c16-439c-9cc9-e4c4a155f0a6"],
Cell[61129, 1560, 745, 22, 32, "Text", "ExpressionUUID" -> \
"7d9b52a3-2b67-47a3-a7c3-bbc9c69dac8a"],
Cell[61877, 1584, 1162, 30, 40, "Text", "ExpressionUUID" -> \
"c7320850-1155-45fb-a479-b0ce8618a311"],
Cell[63042, 1616, 644, 21, 30, "Text", "ExpressionUUID" -> \
"44cfbf50-9cd8-4ccc-b1e9-3cd24716653a"],
Cell[63689, 1639, 1841, 58, 60, "Text", "ExpressionUUID" -> \
"7c12c583-da61-4e5e-b4bb-a7ea22912075"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[65579, 1703, 156, 3, 70, "Section", "ExpressionUUID" -> \
"dae64fe3-d030-402a-99bd-33d99c0fb7f0"],
Cell[65738, 1708, 704, 23, 32, "Text", "ExpressionUUID" -> \
"f42c23bc-d166-4763-8758-4c71e5ee6cd1"],
Cell[CellGroupData[{
Cell[66467, 1735, 158, 3, 49, "Subsection", "ExpressionUUID" -> \
"46d59209-ea8b-4d0e-bb40-f5fc8cc1ff68"],
Cell[66628, 1740, 3709, 106, 237, "Text", "ExpressionUUID" -> \
"019af7f2-2748-4e87-8b0b-edfe03f17335"],
Cell[CellGroupData[{
Cell[70362, 1850, 1282, 38, 50, "Input", "ExpressionUUID" -> \
"01e0dbd4-83fe-4841-b35b-b6530c75e686"],
Cell[71647, 1890, 8919, 170, 234, "Output", "ExpressionUUID" -> \
"9be2c91e-73a9-4653-9ef7-b3220143249a"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[80627, 2067, 158, 3, 70, "Section", "ExpressionUUID" -> \
"64ce845d-da60-4d4e-bfd3-41d25d97b1d1"],
Cell[80788, 2072, 228, 4, 30, "Text", "ExpressionUUID" -> \
"95b56bc2-8c0d-47d9-8d6c-692117207b10"],
Cell[CellGroupData[{
Cell[81041, 2080, 158, 3, 49, "Subsection", "ExpressionUUID" -> \
"440a3662-0c85-49d1-a860-7fa07b4fe907"],
Cell[81202, 2085, 979, 30, 30, "Text", "ExpressionUUID" -> \
"837c07fa-6efd-4047-b91a-2343f80dd406"],
Cell[CellGroupData[{
Cell[82206, 2119, 866, 28, 30, "ItemNumbered", "ExpressionUUID" -> \
"b40a6abc-36fe-4b96-beff-9d06318fed47"],
Cell[83075, 2149, 916, 28, 30, "ItemNumbered", "ExpressionUUID" -> \
"461d1b40-af04-4b47-ab0a-e6f7d228bd2e"],
Cell[83994, 2179, 507, 15, 30, "ItemNumbered", "ExpressionUUID" -> \
"9f3eb5e3-9099-4ba6-a949-4bb9d8751975"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[84562, 2201, 157, 3, 70, "Section", "ExpressionUUID" -> \
"bdb4b9e4-e0e4-4ab5-bc41-4532cfdc2790"],
Cell[84722, 2206, 577, 19, 32, "Text", "ExpressionUUID" -> \
"f48cc877-c2e7-452b-a207-13fd886100f0"],
Cell[CellGroupData[{
Cell[85324, 2229, 158, 3, 49, "Subsection", "ExpressionUUID" -> \
"de2c531a-b567-47ab-8525-e0d55217f1fb"],
Cell[85485, 2234, 5237, 158, 330, "Text", "ExpressionUUID" -> \
"e81e43f7-64ca-4140-8942-2ad46f577b20"],
Cell[CellGroupData[{
Cell[90747, 2396, 429, 14, 30, "Input", "ExpressionUUID" -> \
"93695dad-377f-491e-836c-873f6e0a3672"],
Cell[91179, 2412, 16372, 287, 286, "Output", "ExpressionUUID" -> \
"c5845b3b-0bc9-4612-a1eb-92c71170ffc6"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[107612, 2706, 206, 4, 70, "Section", "ExpressionUUID" -> \
"feb30fc7-7eb1-49f5-9026-f00ef675d0a8"],
Cell[107821, 2712, 926, 23, 49, "Text", "ExpressionUUID" -> \
"664b5388-9817-4cb3-be39-505b6a391a10"],
Cell[CellGroupData[{
Cell[108772, 2739, 155, 3, 49, "Subsection", "ExpressionUUID" -> \
"90218f1d-2563-46c2-bc07-b3d1f819fbd1"],
Cell[108930, 2744, 860, 21, 30, "Text", "ExpressionUUID" -> \
"459ea6f2-5c37-4cc5-9856-e2fd53ee9966"],
Cell[CellGroupData[{
Cell[109815, 2769, 2186, 63, 19, "Input", "ExpressionUUID" -> \
"eca2aa3a-ccb0-4593-b04e-04a35518f519",
 CellOpen->False],
Cell[112004, 2834, 5776, 120, 124, "Output", "ExpressionUUID" -> \
"b7fbeee1-4975-4c16-a5c0-a5b982999dd1"]
}, Open  ]],
Cell[117795, 2957, 4595, 152, 134, "Text", "ExpressionUUID" -> \
"8e212560-f786-4e0a-863b-43b9495615f1"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[122439, 3115, 250, 4, 70, "Section", "ExpressionUUID" -> \
"5c77de86-744f-4564-80aa-3101311579e5"],
Cell[122692, 3121, 260, 6, 30, "Text", "ExpressionUUID" -> \
"fe6795ed-cd95-4433-88e4-73ba1dce8187"],
Cell[CellGroupData[{
Cell[122977, 3131, 158, 3, 49, "Subsection", "ExpressionUUID" -> \
"bb50993f-ff01-4989-8a27-77282f40a142"],
Cell[123138, 3136, 4140, 122, 268, "Text", "ExpressionUUID" -> \
"7ab42d85-0f94-4ff2-9ebc-8610812beda6"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[127327, 3264, 157, 3, 70, "Section", "ExpressionUUID" -> \
"cea77c38-5642-4008-aefa-a9d94db7d931"],
Cell[127487, 3269, 1292, 39, 69, "Text", "ExpressionUUID" -> \
"b5d720be-bb99-4a9a-8f47-a3d97c01d2d4"],
Cell[CellGroupData[{
Cell[128804, 3312, 156, 3, 49, "Subsection", "ExpressionUUID" -> \
"4519b3b8-ed60-4b35-b8f1-b88ab7ac0ec0"],
Cell[128963, 3317, 1108, 28, 49, "Text", "ExpressionUUID" -> \
"71c2505e-ef99-4b3f-9c1f-a4bfcd9da2ea"],
Cell[130074, 3347, 703, 17, 30, "Text", "ExpressionUUID" -> \
"8b79d65e-3616-4966-b30f-0f37edf27c9c"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[130826, 3370, 157, 3, 70, "Section", "ExpressionUUID" -> \
"889b0989-129a-4bd6-9d8f-846d1519f695"],
Cell[130986, 3375, 698, 24, 65, "Text", "ExpressionUUID" -> \
"2f801785-026c-4998-9222-e54092bbcc95"],
Cell[CellGroupData[{
Cell[131709, 3403, 158, 3, 49, "Subsection", "ExpressionUUID" -> \
"c02d4d09-eb90-4c0f-9e84-40f08e87a8e3"],
Cell[131870, 3408, 3241, 99, 195, "Text", "ExpressionUUID" -> \
"0b850305-577a-4ef4-a8bd-f58f767b9f8c"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[135160, 3513, 154, 3, 70, "Section", "ExpressionUUID" -> \
"85a6d833-fa69-48d7-a5ef-d95a0a61ef7f"],
Cell[135317, 3518, 1854, 43, 106, "Text", "ExpressionUUID" -> \
"45e5ac41-63bc-4408-9eb9-b1f999d07e46"],
Cell[CellGroupData[{
Cell[137196, 3565, 156, 3, 49, "Subsection", "ExpressionUUID" -> \
"69f9950d-6ef1-416a-ad15-a8e9d4283abc"],
Cell[CellGroupData[{
Cell[137377, 3572, 399, 11, 30, "Input", "ExpressionUUID" -> \
"3e5ad3dc-c286-4298-b1de-0b5160f4b898"],
Cell[137779, 3585, 17353, 305, 398, "Output", "ExpressionUUID" -> \
"1c5ac548-a0c6-49ff-9446-e15a67771286"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[155193, 3897, 159, 3, 70, "Section", "ExpressionUUID" -> \
"e7dfb4cd-118f-4b28-b71e-67fafcf4ea48"],
Cell[155355, 3902, 1064, 30, 70, "Text", "ExpressionUUID" -> \
"fdb4209a-0ac0-459c-be69-5ec58c49906e"],
Cell[CellGroupData[{
Cell[156444, 3936, 160, 3, 49, "Subsection", "ExpressionUUID" -> \
"3877f47c-b76d-4282-9da6-e2e639b7d746"],
Cell[CellGroupData[{
Cell[156629, 3943, 554, 17, 30, "Input", "ExpressionUUID" -> \
"c38f2b05-bd65-4a0a-a2e3-72168d016260"],
Cell[157186, 3962, 33027, 552, 447, "Output", "ExpressionUUID" -> \
"66fcf747-9574-4139-9d14-7d45fe254f3c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[190250, 4519, 1870, 44, 88, "Input", "ExpressionUUID" -> \
"7ae90c6f-57d7-4ba2-b332-4c635ce10fe8"],
Cell[192123, 4565, 33291, 558, 486, "Output", "ExpressionUUID" -> \
"f6eb5608-0186-447a-b69f-7e24abdf9849"]
}, Open  ]],
Cell[225429, 5126, 718, 21, 32, "Text", "ExpressionUUID" -> \
"0d3f84a4-585a-4444-a841-de4ad4ae295e"],
Cell[CellGroupData[{
Cell[226172, 5151, 530, 16, 30, "Input", "ExpressionUUID" -> \
"b29ac2a1-ddf5-4a35-8a16-46e98e852cec"],
Cell[226705, 5169, 33226, 555, 407, "Output", "ExpressionUUID" -> \
"730031b2-97f4-4739-80ed-abbba817fa4d"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

